/***************************************************************************
                       kcontainerimpl.h  -  description
                             -------------------
    begin                : Mon Oct 16 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.3 $
  
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCONTAINERIMPL_H
#define KCONTAINERIMPL_H

#include <qlist.h>
#include <qintdict.h>
#include "kobjectimpl.h"
//#include "kcontainer.h"

//class KMManagerImpl;
class KContainer;

typedef QIntDict<KObjectImpl> ObjDict;
typedef QIntDictIterator<KObjectImpl> ObjDictIterator;

/** 
 * @short Abstract base class for container objects
 * @author Sergio Moretti
 * @version $Id$
 */

class KContainerImpl : public KObjectImpl {

  Q_OBJECT

  friend class KContainer;
  //friend class KMManagerImpl;

  static const char DOCID[];
  static const char MIMETYPE[][50];
  static const char DOCTYPE[];

public:
  typedef QList<KObjectImpl> List;
  typedef QValueList<int> IntList;

  virtual ~KContainerImpl();

  /** document name */
  virtual const char * docId() const { return DOCID; }
  /** dom document type */
  virtual const char * docType() const { return DOCTYPE; }
  /** mime type */
  virtual const char * mimeType(int i) const { return MIMETYPE[i]; }

  QDomDocument domDoc() const { return _doc; }
  QDomElement domGlobals() const { return _domGlobals; }
  QDomElement domItems() const { return _domItems; }

  /** activate/disactivate an item */
  virtual void itemActivate(bool on);
  /** copy an item from DOM element */
  virtual KObjectImpl * itemCopy(const QDomElement &e);
  /** remove an item */
  virtual void itemRemove(KObjectImpl *item);
  /** called from child item when its state change */
  virtual void itemChanged(KObjectImpl *item, ModType type, PropMode prop);
  /** find a global instance of type type */
  virtual KObjectImpl * findGlobal(int type);
  const ObjDict & globals() const { return _glbDict; }

protected:
  // Object Creation and Initialization
  KContainerImpl(int type);

  virtual void loadData();
  /** update DOM to current state */
  void updateState();
  
  // Operation on object

  virtual void runPeriodically();

  // Container Operations
  
  virtual bool isEmpty() const { return _items.isEmpty(); }
  virtual void clear();
  virtual KObjectImpl * itemFindId(int id);
  virtual int itemFind(const KObjectImpl *item) { return _items.find(item); }
  virtual KObjectImpl * itemAt(int index) { return _items.at(index); }
  virtual KObjectImpl * itemFirst() { return _items.first(); }
  virtual KObjectImpl * itemLast() { return _items.last(); }
  virtual KObjectImpl * itemNext() { return _items.next(); }
  virtual KObjectImpl * itemPrev() { return _items.prev(); }
  virtual int itemCount() const { return _items.count(); }
  virtual int itemActiveCount() const { return _itemActiveCount; }
  /** add an item */
  virtual bool itemAdd(KObjectImpl *item);
  /** create an uninitialized item */
  virtual KObjectImpl * itemCreate(int type);
  /** load an item from DOM element, and associate DOM element to object */
  virtual KObjectImpl* itemLoad(const QDomElement &e);
  virtual bool itemMove(KObjectImpl *item, KContainerImpl *to);
  virtual KObjectImpl* itemNew(int type);
  /** call to check that item is insertable */
  virtual bool isItemInsertable(const KObjectImpl *) { return true; }

  /** assign an id */
  virtual int assignId() { return container()->assignId(); }

  // operations on globals

  virtual KObjectImpl * globalNew(int type);
  virtual KObjectImpl * globalLoad(const QDomElement &e);

protected:
  int _itemActiveCount;
  /** global dom document */
  QDomDocument _doc;
private:
  /** items list */
  List _items;
  /** dom element containing items */
  QDomElement _domItems;
  /** dictionary of global items */
  ObjDict _glbDict;
  /** dom element containing global items */
  QDomElement _domGlobals;
  /** type of items */
  int _itemType;
};

#endif // KCONTAINERIMPL_H

/* Local Variables: */
/* mode: c++ */
/* End: */
