/***************************************************************************
			   kdlgopentransfer.h  -  description
                             -------------------
    begin                : Fri Sep 15 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision						 : $Revision: 1.6 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDLGOPENTRANSFER_H
#define KDLGOPENTRANSFER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//Generated area. DO NOT EDIT!!!(begin)
#include <qwidget.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <kurlrequester.h>
#include <kcombobox.h>
//Generated area. DO NOT EDIT!!!(end)

#include <klocale.h>
#include <qdialog.h>
#include <qdir.h>
#include <kurl.h>
#include <qfileinfo.h>
#include <qvaluelist.h>
//#include <qdir.h>

#ifdef DMALLOC
#include <dmalloc.h>
#endif

class KTManager;

/**
  *@author Sergio Moretti
  */

class KDlgOpenTransfer : public QDialog  {
  Q_OBJECT

public:
  KDlgOpenTransfer(QWidget *parent, const char *name=0);
  ~KDlgOpenTransfer();
  static bool getOpenTransfer(KTManager m, KURL &rmt, KURL &lcl, 
			      int &type, int flgs);
  virtual QSize sizeHint() const { return QSize(320, 200); }
protected:
  void init(KTManager m, const KURL &rmt, const KURL &lcl, int type, int flgs);
  void initDialog();
  /** correct file name */
  QString correctFile(const QString &f);
  /** correct url */
  //KURL correctURL(const QString &u);

protected slots:
  /** open file dialog to select filename */
  //void slotOpenFileDlg();
  /** close the dialog acceptiong the selection */
  void accept();

public slots: // Public slots
  /** create the file name, based on the url */
  void slotReadURL(const QString &u);

protected:
  KComboBox *cmbURL;
  KURLRequester *cmbFile;
  KComboBox *cmbType;

private:
  /** file to write */
  KURL _lcl;
  /** url to download */
  KURL _rmt;
  /** download dir */
  QDir _dir;
  /** transfer type */
  int _type;
  /** convert index to type */
  QValueList<int> _typeList;
  /** flags */
  int _flags;
  /** dialog instance */
  static KDlgOpenTransfer *dlg;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
