/***************************************************************************
                          kfactoryimpl.h  -  description
                             -------------------
    begin                : Mon Oct 16 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.3 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFACTORYIMPL_H
#define KFACTORYIMPL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdom.h>
#include <qintdict.h>
#include "kobjectimpl.h"

#ifdef DMALLOC
#include <dmalloc.h>
#endif

/** Factory class for KObject's hierarchy */

class KFactoryImpl {
public:
  typedef QIntDict<char> TypDict;
  typedef QIntDictIterator<char> TypDictIterator;
  //FIXME!! duplicated from KContainerImpl 
  typedef QIntDict<KObjectImpl> ObjDict;
  typedef QIntDictIterator<KObjectImpl> ObjDictIterator;

  static KFactoryImpl * factory();

  KObjectImpl * createObject(int type);
  KObjectImpl * prototype(int type);
  QString typeStr(int type);
  QString docId(int type);
  QValueList<int> typeList(int type);
  void addPrototype(int type, const KObjectImpl *obj, const char *typeStr);

protected:
  KFactoryImpl();
  virtual ~KFactoryImpl();

private:
  ObjDict objDict;
  TypDict typDict;
  static KFactoryImpl *_factory;
};

#endif // KFACTORYIMPL_H

/* Local Variables: */
/* mode: c++ */
/* End: */
