/***************************************************************************
                          km.h  -  description
                             -------------------
    begin                : Tue Oct 17 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.5 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KM_H
#define KM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <exception>
#include <qstring.h>

namespace KM {

  // debug areas
  enum DebugAreas {
    D_INI =    41000,
    D_VIE =    41001,
    D_RUN =    41002,
    D_PRS =    41003
  };

  class Error : public exception {
  public:
    Error(const QString &name, const QString &descr) {
      _what = QString("%1: %2").arg(name).arg(descr);
    }
    QString what() { return _what; }
  protected:
    Error() {}
  protected:
    QString _what;
  };

  class DomError : public Error {
  public:
    DomError(const QString &name, const QString &descr, QDomNode n) {
      _what = QString("%1 : %2:\n%3").arg(name).arg(descr).arg(n.ownerDocument().toString());
    }
  };

  enum ObjectTypes {
    TYP_OBJECT_T   = 0xf0,
    TYP_MMANAGER_T = 0x10,
    TYP_MMANAGER   = 0x11,
    TYP_TMANAGER_T = 0x20,
    TYP_TMANAGER   = 0x21,
    TYP_TRANSFER_T = 0x40,
    TYP_TWGET      = 0x41,
    TYP_TKIO       = 0x42
  };

  enum ModType {
    MOD_STATE    =  0x01,
    MOD_CONF     =  0x02,
    MOD_ALL      =  0x03, // MOD_STATE | MOD_CONF
    MOD_READ     =  0x04,
    MOD_ADD      =  0x08,
    MOD_REMOVE   =  0x10,
    MOD_VIEW     =  0x20,
    MOD_ERR      =  0x40,
    MOD_ANY      =  0x7f
  };

  // notify propagation mode
  enum PropMode {
    PRP_NONE,
    PRP_THIS,
    PRP_ALL
  };

  // TRANSFER

  // transfer status
  enum Status {
    TRN_READY = 0,
    TRN_START,
    TRN_CONNECT,
    TRN_DOWNLOAD,
    TRN_FINISH
  };
  
  // transfer command status
  enum CommandStatus {
    CMD_RUNNABLE = 0,
    CMD_EXITED,
    CMD_KILLED,
    CMD_FATALERROR,
    CMD_RUNNING
  };

  enum ResumeStatus {
    RSM_UNKNOWN = 0,
    RSM_CHECKING,
    RSM_CHECKFAIL,
    RSM_YES,
    RSM_NO
  };

  enum PriorityPolicy {
    PRI_FIFO = 0,
    PRI_LIFO,
    PRI_SHORT,
    PRI_LONG,
    PRI_USER
  };

  // END TRANSFER

  // WGET

  /** protocols supported */
  enum Protocol {
    FTP = 1,
    HTTP
  };

  enum TransferSpeed {
    SPD_DEFAULT = 0,
    SPD_BINARY,
    SPD_MEGA,
    SPD_MICRO
  };

  // END WGET

  // KMAGOAPP

  enum OpenFlags {
    FLG_FILE_AUTO_ENCODE =   0x001,
    FLG_FILE_FORCE_ENCODE =  0x002,
    FLG_NO_PROMPT =          0x004
  };
  
  enum StartMode {
    START_NOW    = 0,
    START_PROMPT,
    START_NO
  };
  
  enum IDs {
    STATUS_MSG   = 0,
    STATUS_COUNT,
    STATUS_BAND,
    STATUS_GLB_COUNT,
    STATUS_GLB_BAND
  };

  // END KMAGOAPP

} // namespace

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
