/***************************************************************************
                          kgetview.h  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.11 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMAGOVIEW_H
#define KMAGOVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qwidget.h>
#include <klistview.h>
#include <klistbox.h>
#include <qsplitter.h>
#include <qdatetime.h>
#include "ktransfer.h"
#include "ktmanager.h"

#ifdef DMALLOC
#include <dmalloc.h>
#endif


class KMagoDoc;
class KMagoApp;

class ManagerView : public KListBox {

  Q_OBJECT

public:
  ManagerView(QWidget *parent, const char *name = 0);
  virtual ~ManagerView() {}

  //virtual QSize sizeHint() const { return QSize(200, 100); }
  //virtual QSize minimumSizeHint() const { return QSize(60,30); }

protected:
  virtual void dragEnterEvent(QDragEnterEvent *event);
  virtual void dragMoveEvent(QDragMoveEvent *event);
  //virtual void dragLeaveEvent(QDragLeaveEvent *event);
  virtual void dropEvent(QDropEvent *event);
  virtual void mouseReleaseEvent(QMouseEvent *event);
  virtual void mouseMoveEvent(QMouseEvent *event);

protected slots:
  void slotRightButtonPressed(QListBoxItem *item, const QPoint &p);
  
private:
  bool dragState;
};

class TransferView : public KListView {
  Q_OBJECT

public:
  TransferView(QWidget *parent, const char *name = 0);
  virtual ~TransferView() {}

protected:
  virtual void startDrag();
  virtual QDragObject* dragObject();
  virtual bool acceptDrag(QDropEvent *event) const;

protected slots:
  void slotDropped(QDropEvent *e, QListViewItem *after);
  void slotExecuted(QListViewItem *item);
  void slotContextMenu(KListView *l, QListViewItem *i, const QPoint &p);
};

class ManagerItem : public QListBoxText {
public:
  ManagerItem(KTManager mngr, KListBox *parent, const QString &text);
  virtual ~ManagerItem() {}
  KTManager manager() const { return m; }

protected:
  //void activate();

private:
  KTManager m;
};
    
class TransferItem : public QListViewItem {
public:
  TransferItem(KListView *parent, KTransfer tr);
  virtual ~TransferItem() {}
  virtual QString text(int column) const;
  virtual QString key(int column, bool ascending) const;
  KTransfer transfer() const { return t; }
  /** update the icons visualization */
  void update();

protected:
  //void activate();

private:
  KTransfer t;
};

/** The KMagoView class provides the view widget for the KMagoApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KMagoView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KMagoApp class to manipulate and display
 * the document structure provided by the KMagoDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KMagoView : public QSplitter {

  Q_OBJECT

  friend class TransferView;
  friend class ManagerView;

public:
  /** Constructor for the main view */
  KMagoView(QWidget *parent, const char *name=0);
  /** Destructor for the main view */
  ~KMagoView();
  
  /** contains the implementation for printing functionality */
  void print(QPrinter *pPrinter);

  /** add a manager to the view */
  void addManager(KTManager m);
  /** remove a manager from view */
  void removeManager(KTManager m);
  /** change the selected manager in response to a change in the current item */
  void selectManager(KTManager m);
  /** reset manager view */
  void resetManager(KTManager m);

  /** add a transfer to the view */
  void addTransfer(KTransfer t);
  /** remove a transfer from view */
  void removeTransfer(KTransfer t);
  /** change the selected item in response to a change in the current item */
  void selectTransfer(KTransfer t);
  /** update the visualization of the item */
  void updateTransferText(KTransfer t);
  /** update the visualization of the item */
  void updateTransfer(KTransfer t);

  /** reset view */
  void reset();

  /** show/hide managers listbox */
  void showManagers(bool on);
  /** set split orientation */
  void setOrientation(bool vert);
  
protected:
  void initListView();
  void initListBox();

  KMagoApp * mainView() const;  
  /** returns a pointer to the document connected to the view instance. Mind that this method requires a KMagoApp instance as a parent
   * widget to get to the window document pointer by calling the KMagoApp::getDocument() method.
   *
   * @see KMagoApp#getDocument
   */
  KMagoDoc *getDocument() const;

  /** find item associated to transfer */
  TransferItem* findTransfer(KTransfer t) const;
  /** find item associated to manager */
  ManagerItem* findManager(KTManager m) const;
	
protected slots: // Protected slots
  /** change the current manager/transfer in response to a change in the selected item */
  void slotSetCurrentManager(QListBoxItem *item);
  void slotSetCurrentTransfer(QListViewItem *item);

private:
  ManagerView * _lbManager;
  TransferView * _lvTransfer;
};

#endif // KMAGOVIEW_H

/* Local Variables: */
/* mode: c++ */
/* End: */
