/***************************************************************************
                          ktransferkioimpl.cpp  -  description
                             -------------------
    begin                : Sun Nov 5 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef ENABLE_KIO

#include <kdebug.h>
#include <qfileinfo.h>
#include <qdir.h>
#include "ktmanagerimpl.h"
#include "ktransferkioimpl.h"


KTransferKioImpl::KTransferKioImpl(int type) : KTransferImpl(type) {
  _job = 0;
  _startDownload = false;
  connect(&_waitRetry, SIGNAL(timeout()),
	  this, SLOT(slotRetryTimeout()));
}

KObjectImpl* KTransferKioImpl::clone() const {
  return new KTransferKioImpl(type());
}

KURL KTransferKioImpl::getTempFile(const KURL &rmt, const KURL &) const {
  KURL tmp;
  tmp.setPath(QFileInfo(manager()->getWorkingDir(), 
		   rmt.fileName()).absFilePath());
  return tmp;
}

bool KTransferKioImpl::isRunning() const {
  return KTransferImpl::isRunning() || _job != 0;
}

bool KTransferKioImpl::isProtocolSupported(const QString &proto) const {
  return (proto == "ftp");
}

const KTransferKioImpl * KTransferKioImpl::global() const {
  return dynamic_cast<const KTransferKioImpl*>(KTransferImpl::global());
}

void KTransferKioImpl::startJob() {
  kdFatal(_job != 0, D_RUN) << name() << ": start job != 0" << endl;
  _startDownload = true;
  QString filename = getTmpFile().path();
  bool resume = QDir::current().exists(filename);
  _job = KIO::file_copy(remote(), local(), -1, false, resume, false);
  connect(_job, SIGNAL(result(KIO::Job *)),
	  this, SLOT(slotResult(KIO::Job*)));
  //connect(_job, SIGNAL(connected(KIO::Job*)),
  //	  this, SLOT(slotConnected(KIO::Job*)));
  connect(_job, SIGNAL(totalSize(KIO::Job*, unsigned long)),
	  this, SLOT(slotTotalSize(KIO::Job*, unsigned long)));
  connect(_job, SIGNAL(processedSize(KIO::Job*, unsigned long)),
	  this, SLOT(slotProcessedSize(KIO::Job*, unsigned long)));
  connect(_job, SIGNAL(infoMessage(KIO::Job*, const QString &)),
	  this, SLOT(slotInfoMessage(KIO::Job*, const QString &)));
  opRunStart();
}

bool KTransferKioImpl::processStart() {
  QString tmpfile = getTmpFile().path();
  if (QDir::current().exists(tmpfile))
    QDir::current().rename(tmpfile, tmpfile + ".part");
  opProcessStart();
  startJob();
  return true;
}

bool KTransferKioImpl::processKill() {
  if (_job)
    _job->kill(false);
  _waitRetry.stop();
  return true;
}

//////////// SLOTS

void KTransferKioImpl::slotResult(KIO::Job *) {
  kdDebug(D_RUN) << name() << ": slave finish" << endl;
  QString tmpfile = getTmpFile().path();
  unsigned int size = QFileInfo(tmpfile + ".part").size();
  if (size > (unsigned int)partial())
    opDataRead(size - partial());
  bool killed = false;
  setCmdStatus(CMD_EXITED);
  if (_job->error()) {
    bool error = true;
    switch (_job->error()) {
    case KIO::ERR_COULD_NOT_CONNECT:
    case KIO::ERR_CONNECTION_BROKEN:
    case KIO::ERR_ABORTED:
    case KIO::ERR_INTERNAL_SERVER:
    case KIO::ERR_SERVER_TIMEOUT:
    case KIO::ERR_SERVICE_NOT_AVAILABLE:
      break;
    case KIO::ERR_CANNOT_RESUME:
      setRsmStatus(RSM_NO);
      killed = true;
      break;
    case KIO::ERR_COULD_NOT_READ:
      if (rsmStatus() == RSM_CHECKING) {
	setRsmStatus(RSM_NO);
	killed = true;
      } else
	setCmdStatus(CMD_FATALERROR);
      break;
    case KIO::ERR_USER_CANCELED:
      killed = true;
      error = false;
      break;
    default:
      setCmdStatus(CMD_FATALERROR);
    }
    if (rsmStatus() == RSM_CHECKING)
      setRsmStatus(RSM_CHECKFAIL);
    opError(_job->errorString());
  }
  opRunEnd();
  if (_job->error() == 0 || retry() >= getMaxRetry() || killed 
      || cmdStatus() == CMD_FATALERROR) {
    if (QDir::current().exists(tmpfile + ".part"))
      QDir::current().rename(tmpfile + ".part", tmpfile);
    opProcessEnd(_job->error());
  } else
    _waitRetry.start(getWaitRetry()*1000, true);
  _job = 0;
}

//void KTransferKioImpl::slotConnected(KIO::Job *) {
//  opConnect();
//}

void KTransferKioImpl::slotTotalSize(KIO::Job*, unsigned long size) {
  opConnect();
  setLen(size);
}

void KTransferKioImpl::slotProcessedSize(KIO::Job*, unsigned long size) {
  if (_startDownload) {
    setPartial(size);
    opDownload();
    _startDownload = false;
    if (rsmStatus() == RSM_CHECKING)
      setRsmStatus(RSM_YES);
  } else 
    opDataRead(size - partial());
}

void KTransferKioImpl::slotInfoMessage(KIO::Job*, const QString &msg) {
  opProcessOutput(msg + '\n');
}

void KTransferKioImpl::slotRetryTimeout() {
  startJob();
}

#include "ktransferkioimpl.moc"

#endif
