/*
    KMLOCfg
    
    A utility to configure the ELSA MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <termios.h>
#include <stdlib.h>

#include <qglobal.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qradiobutton.h>
#include <qtooltip.h>
#include <qstring.h>

#include <kapp.h>
#include <kiconloader.h>
#include <klocale.h>

#include "configure.h"
#include "global.h"



Configure *configure = 0;


Configure::Configure(QWidget *parent, const char *name, bool modal) : KDialogBase (IconList, i18n("Configure"), Help|Default|Ok|Apply|Cancel, Ok, parent, name, modal, true)
{
	QGridLayout *grid;
	QBoxLayout *vbox, *svbox;
	QLabel *label;
	QGroupBox *gb;
	QFrame *page;

	config = kapp->config();

	gotToolTips = false;

	setHelp("CONFIGURE-HELP");
	setIconListAllVisible(true);
	
	/* Page 1: General */
	page = addPage(i18n("General"), i18n("General Settings"), UserIcon("general"));
	
	vbox = new QVBoxLayout(page, 12);

	gb = new QGroupBox(i18n("User Interface"), page);
	svbox = new QVBoxLayout(gb, 10);
	svbox->addSpacing(8);

	gen_tooltips = new QCheckBox(i18n("Show tooltips"), gb);
	gen_tooltips->setMinimumSize(gen_tooltips->sizeHint());
	svbox->addWidget(gen_tooltips);
	svbox->activate();
	
	vbox->addWidget(gb);

	vbox->addStretch(1);
	vbox->activate();

	/* Page 2: Modem */
	page = addPage(i18n("Modem"), i18n("Settings for the Modem"), UserIcon("modem"));
	
	vbox = new QVBoxLayout(page, 12);

	gb = new QGroupBox(i18n("Modem Device"), page);

	grid = new QGridLayout(gb, 3, 3, 12);

	grid->addRowSpacing(0, fontMetrics().lineSpacing());

	label = new QLabel(i18n("Device:"), gb);
	label->setMinimumSize(label->sizeHint());
	grid->addWidget(label, 1, 0);

	mod_device = new QLineEdit(gb);
	mod_device->setMinimumSize(mod_device->sizeHint());
	grid->addMultiCellWidget(mod_device, 1, 1, 1, 2);

	label = new QLabel(i18n("Speed:"), gb);
	label->setMinimumSize(label->sizeHint());
	grid->addWidget(label, 2, 0);

	mod_speed = new QComboBox(false, gb);
	mod_speed->insertItem(" 19200 Bps ", 0);
	mod_speed->insertItem(" 38400 Bps ", 1);
#ifdef B57600
	mod_speed->insertItem(" 57600 Bps ", 2);
#endif
#ifdef B115200
	mod_speed->insertItem(" 115200 Bps ", 3);
#endif
#ifdef B230400
	mod_speed->insertItem(" 230400 Bps ", 4);
#endif
	mod_speed->setMinimumSize(mod_speed->sizeHint());
	grid->addWidget(mod_speed, 2, 1);

	grid->setColStretch(2, 1);

	grid->activate();

	vbox->addWidget(gb);
	vbox->addStretch(1);
	vbox->activate();

	reset();
}


Configure::~Configure()
{
}


void Configure::addToolTips(bool on)
{
	if (on == gotToolTips)
		return;

	gotToolTips = on;

	if (gotToolTips) {
		QToolTip::add(gen_tooltips, i18n("Show tooltips in dialogs"));
		QToolTip::add(mod_device, i18n("Device of the modem"));
		QToolTip::add(mod_speed, i18n("Speed for serial communication"));
	}
	else {
		QToolTip::remove(gen_tooltips);
		QToolTip::remove(mod_device);
		QToolTip::remove(mod_speed);
	}
}	


void Configure::slotDefault()
{
	gen_tooltips->setChecked(PREF_GEN_TOOLTIPS);

	mod_device->setText(PREF_MOD_DEVICE);
	mod_speed->setCurrentItem(PREF_MOD_SPEED);
}


void Configure::slotOk()
{
	slotApply();
	hide();
}


void Configure::slotApply()
{
	config->setGroup(ID_PREF_GROUP_GENERAL);
	config->writeEntry(ID_PREF_GEN_TOOLTIPS, gen_tooltips->isChecked());
	
	config->setGroup(ID_PREF_GROUP_MODEM);
	config->writeEntry(ID_PREF_MOD_DEVICE, mod_device->text());
	config->writeEntry(ID_PREF_MOD_SPEED, mod_speed->currentItem());

	config->sync();

	emit newConfig();
}


void Configure::slotCancel()
{
	reset();
	hide();
}


void Configure::reset()
{
	int speed;

	config->setGroup(ID_PREF_GROUP_GENERAL);
	gen_tooltips->setChecked(config->readBoolEntry(ID_PREF_GEN_TOOLTIPS, PREF_GEN_TOOLTIPS));

	config->setGroup(ID_PREF_GROUP_MODEM);
	mod_device->setText(config->readEntry(ID_PREF_MOD_DEVICE, PREF_MOD_DEVICE));
	speed = config->readNumEntry(ID_PREF_MOD_SPEED, PREF_MOD_SPEED);
	if ((speed < 0) || (speed > 4))
		speed = PREF_MOD_SPEED;
	mod_speed->setCurrentItem(speed);
}
