/*
    KMLOVoice

    A utility to process voice messages received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#include <qglobal.h>

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kmlovoice.h"


static const char *description =
	I18N_NOOP("KMLOVoice");
	
	
int main(int argc, char *argv[])
{
  KAboutData aboutData("kmlovoice", I18N_NOOP("KMLOVoice"),
    VERSION, description, KAboutData::License_GPL,
    "(C) 2000, Oliver Gantz");
  aboutData.addAuthor("Oliver Gantz", 0, "Oliver.Gantz@epost.de");
  KCmdLineArgs::init(argc, argv, &aboutData);

  KApplication a;
  KMLOVoice *kmlovoice = new KMLOVoice(0, "mainwindow");
  CHECK_PTR(kmlovoice);
  a.setMainWidget(kmlovoice);
  kmlovoice->setCaption(QString::null);
  kmlovoice->show();

  return a.exec();
}
