/***************************************************************************
                          helpfuncs.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Henrik Stormer
    email                : stormer@ifi.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "helpfuncs.h"

QString createAttribString(int permissions)
{
   QString Attrib;

   if (S_IRUSR & permissions) Attrib += "r"; else Attrib += "-";
   if (S_IWUSR & permissions) Attrib += "w"; else Attrib += "-";
   if (S_IXUSR & permissions) Attrib += "x"; else Attrib += "-";

   if (S_IRGRP & permissions) Attrib += "r"; else Attrib += "-";
   if (S_IWGRP & permissions) Attrib += "w"; else Attrib += "-";
   if (S_IXGRP & permissions) Attrib += "x"; else Attrib += "-";

   if (S_IROTH & permissions) Attrib += "r"; else Attrib += "-";
   if (S_IWOTH & permissions) Attrib += "w"; else Attrib += "-";
   if (S_IXOTH & permissions) Attrib += "x"; else Attrib += "-";

   return Attrib;
}

QString formatLong(long Number)
{
  QString Res;
  Res.setNum(Number);
  int i= Res.length();
  int count = 3;
  while (i>0)
  {
    i-=count;
    if (i>0) Res.insert(i, ".");
  }
 return Res;
}
