/***************************************************************************
                          kncdirectorytoolbar.cpp  -  description
                             -------------------
    begin                : Wed Aug 30 2000
    copyright            : (C) 2000 by Henrik Stormer
    email                : stormer@ifi.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include "kncdirectorytoolbar.h"
#include "kurlcompletion.h"

KNCDirectoryToolBar::KNCDirectoryToolBar(QWidget *parent, const char *name )
: KToolBar(parent,name), _ParentWindow(parent)
{
 _Left = new KLineEdit(this);
 KURLCompletion *compl1 = new KURLCompletion();
 _Left->setCompletionObject( compl1 );

 _Right = new KLineEdit(this);
 KURLCompletion *compl2 = new KURLCompletion();
 _Right->setCompletionObject( compl2 );

 setFullSize();
}

KNCDirectoryToolBar::~KNCDirectoryToolBar()
{
}


void KNCDirectoryToolBar::resizeEvent(QResizeEvent* e)
{
 int w = (e->size().width() / 2) - 12;
 _Left->resize(w, _Left->height());
 _Left->setMinimumWidth(w);
 _Left->setMaximumWidth(w);

 _Right->resize(w, _Right->height());
 _Right->move(w+15, _Right->y());
 _Right->setMinimumWidth(w);
 _Right->setMaximumWidth(w);
}