/***************************************************************************
                          kncfilecommand.h  -  description
                             -------------------
    begin                : Tue Aug 29 2000
    copyright            : (C) 2000 by Henrik Stormer
    email                : stormer@ifi.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNCFILECOMMAND_H
#define KNCFILECOMMAND_H

#include <qobject.h>
#include <kurl.h>
#include <qmap.h>
#include <kio/jobclasses.h>
/**
  *@author Henrik Stormer
  */

class KNCFileCommand : public QObject  {
   Q_OBJECT
public: 

 ~KNCFileCommand();

 void copy(const KURL::List& SourceList, const KURL& Dest);
 void move(const KURL::List& SourceList, const KURL& Dest);
 void link(const KURL::List& SourceList, const KURL& Dest);

 void newDir(const KURL& NewDir);
 void deleteFiles(const KURL::List& SourceList);

 void setShowDeleteMessageBox (bool Show) {_bShowDeleteMessageBox = Show;}
 bool getShowDeleteMessageBox () {return _bShowDeleteMessageBox;}

 static KNCFileCommand& instance() {if (!_instance) _instance = new KNCFileCommand; return *_instance;}

 protected:

	KNCFileCommand();

 public slots:

 private:

  static KNCFileCommand*     _instance;
  QMap<KIO::Job*, QDialog*>  _DialogMap;
  bool                       _bShowDeleteMessageBox;

};

#endif
