#ifndef KNAT_DEBUG_H
#define KNAT_DEBUG_H


#include <stdio.h>



/* some global settings */

#define DEBUG_LEVEL 11

/* debug levels */

#define FATAL   	1   /* imminant program failure */
#define URGENT  	2   /* likely program failure eventually */
#define NOTIFY  	4   /* important information */
#define LAZY    	7
#define INFO    	8
#define KNFDEBUG  	9   /* debug info: variable values, etc... */
#define CHCKPNT 	10  /* debug checkpoints to track position of crash */

#define OUT(format, args...)  { fprintf(stdout, format , ## args); \
                                fprintf(stdout, "\n"); }
#define ERR(format, args...)  { fprintf(stderr, format , ## args); \
                                fprintf(stderr, "\n"); }
#define DBG(dbglevel, format, args...)  if (dbglevel < DEBUG_LEVEL) \
                 {  \
                    fprintf(stderr, "DEBUG -- %s -- (file \"%s\", line %d): ", \
                            PROGRAM_NAME, __FILE__, __LINE__); \
                    fprintf(stderr, format , ## args); \
                    fprintf(stderr, "\n"); \
                 }





#endif /* KNAT_DEBUG_H */
