/***************************************************************************
                          kurllaunch.cpp  -  description
                             -------------------
    begin                : Die Mr 20 20:13:29 CET 2001
    copyright            : (C) 2001 by Jochen Schmitt
    email                : Jochen@herr-schmitt.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kmenubar.h>
#include <kpopupmenu.h>
#include <khelpmenu.h>
#include <klocale.h>
#include <qlistbox.h>

#include "kurllaunch.h"
#include "kurllaunch_rc.h"

#include "mybrowserinfo.h"
#include "kabout.h"

KURLLaunch::KURLLaunch(QWidget *parent, const char *name)
	: KMainWindow(parent, name)
{
	Form1 *dialog = new Form1(this);
	setCaption(i18n("Configuration"));
	listbox = dialog->Liste;
	listbox->clear();
	gmbinfo->fillListbox(listbox);
	setCentralWidget(dialog);
	KPopupMenu *file = new KPopupMenu(this);
	KAction *quitact = KStdAction::quit(this, SLOT(beenden()));
	quitact->plug(file);
	menuBar()->insertItem(i18n("&File"), file);
	KHelpMenu *help = new KHelpMenu(this, "", false);
	connect(help, SIGNAL(showAboutApplication()), this, SLOT(aboutapp()) );
	menuBar()->insertItem(i18n("&Help"), help->menu());
}

KURLLaunch::~KURLLaunch()
{
}
/** No descriptions */
void KURLLaunch::beenden(){
 gmbinfo->setSelected(listbox->currentText());
 kapp->quit();
}
/** No descriptions */
void KURLLaunch::aboutapp(){
  KAbout *dialog = new KAbout(0, "");
  dialog->show();
}
