/**
 * hosttoken.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#include "hosttoken.h"
#include "applicationtoken.h"

using namespace KCfgCreator;

HostToken::HostToken( const KURL& url, const QString& name )
    : Token( name ), m_url( url )
{
}

KURL
HostToken::url() const
{
    return m_url;
}

QPtrList<ApplicationToken>
HostToken::applications()
{
    return m_tokens;
}

void
HostToken::addApp( ApplicationToken* token )
{
    m_tokens.append( token );
}

void
HostToken::removeApp( const QString& name )
{
}

ApplicationToken*
HostToken::application( const KURL& url )
{
    QPtrListIterator<ApplicationToken> itr( m_tokens );
    while ( itr.current() ) {
        if ( itr.current()->url() == url )
            return itr.current();
        ++itr;
    }
    return 0;
}
