/**
 * kernel.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#include "kernel.h"

#include "configmanager.h"
#include "progressmanager.h"

#include <klocale.h>
#include <kstaticdeleter.h>
#include <qtimer.h>

using namespace KConfigEditor;

Kernel *Kernel::s_self = 0;

static KStaticDeleter<Kernel> sd;

Kernel * Kernel::self()
{
    if ( !s_self ) {
        sd.setObject( s_self, new Kernel( 0 ) );
    }
    return s_self;
}

void Kernel::emitStatusMsg( const QString &msg )
{
    emit statusMsg( msg );
}

Kernel::Kernel( QObject *parent )
    : QObject( parent )
{
    m_manager = new ConfigManager( this );
    QTimer::singleShot( 0, this, SLOT(startInitialization()) );
}

void Kernel::startInitialization()
{
}


ProgressItem *Kernel::globalProgress() const
{
    if ( !m_globalProgressItem )
        m_globalProgressItem = ProgressManager::createProgressItem( i18n( "Total Progress" ) );
    return m_globalProgressItem;
}

#include "kernel.moc"
