/**
 * gnomesubsystem.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef GNOMESUBSYSTEM_H
#define GNOMESUBSYSTEM_H

#include "interfaces/subsystem.h"

class KURL;
class QVariant;
class QCustomEvent;

namespace KConfigEditor
{
    class ConfigurationView;
    class GroupToken;
    class GNOMEApp;
    class GNOMESubsystem : public Subsystem
    {
        Q_OBJECT
    public:
        GNOMESubsystem( QObject *parent );

        virtual QString protocol() const
        {
            return "gnome";
        }

        void customEvent( QCustomEvent * );

        GroupToken *createTopLevelToken( const QString &name );
    public slots:
        virtual void setValue( const KURL &item, const QVariant &value );
        virtual void saveToken( EntryToken *token );
        virtual void parse( ConfigurationView *view );

    protected:
        virtual void saveConfig( GroupToken *token );

        void startAttaching();
        void attachGroup( GroupToken *token );
    private:
        ConfigurationView *m_view;
        GNOMEApp *m_app;
        bool      m_doneParsing;
        bool      m_parseRequest;
    };
}

#endif
