/**
 * treeitems.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#ifndef KCONFED_TREEITEMS_H
#define KCONFED_TREEITEMS_H

#include <klistview.h>
#include <kurl.h>

#include <qmap.h>
#include <qstringlist.h>


namespace KConfigEditor
{
    class EntryToken;
    class GroupToken;
    class Token;

    class ConfItem : public KListViewItem
    {
    public:
        enum Type {
            None=0,
            Entry,
            Group,
            Protocol
        };
        ConfItem( KListView *parent, const QString &name );
        ConfItem( ConfItem *parent, Token *token );

        virtual QString     name() const =0;
        virtual Type        type() const =0;

        KURL url() const;
    };

    class ProtocolItem : public ConfItem
    {
    public:
        ProtocolItem( KListView *parent, const QString &name );
        QString name() const { return text( 0 ); }
        Type type() const { return Protocol; }
    };

    class GroupItem : public ConfItem
    {
    public:
        GroupItem( ConfItem *parent, GroupToken* token );

        QString name() const;
        Type type() const { return Group; }

        void updateIcon();

        EntryToken *entry( const QString & );

        GroupToken *group() const;
    private:
        GroupToken *m_token;
    };

    class EntryItem : public ConfItem
    {
    public:
        EntryItem( GroupItem *parent, EntryToken *token );

        EntryToken *token() const { return m_token; }
        QString name() const;
        Type type() const { return Entry; }

        QString value() const;
        void update();

    private:
        EntryToken *m_token;
    };

}

#endif
