/**
 * configmanager.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef CONFIGMANAGER_H
#define CONFIGMANAGER_H

#include <qobject.h>
#include <qdict.h>

namespace KConfigEditor
{
    class Subsystem;
    class ScriptGenerator;
    class ConfigurationView;
    class EntryToken;
    class ConfigManager : public QObject
    {
        Q_OBJECT
    public:
        ConfigManager( QObject *parent );

        QString backupScript();
        QString propagationScript();
        QString fullBackupScript();
    public slots:
        void parse( ConfigurationView *view );
        void save();
        void saveToken( EntryToken *token );
        void showChangesView();
    signals:
        void parsingFinished();

    protected slots:
        void slotParsingFinished( Subsystem *sub );
    private:
        void initSubsystems();
        void initGenerators();
    private:
        QDict<Subsystem> m_subsystems;
        QDict<ScriptGenerator> m_generators;
        int m_waitingParsers;
    };


}

#endif
