/**
 * configsearchline.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#include "configsearchline.h"

#include "treeitems.h"
#include "grouptoken.h"

#include <kdebug.h>

using namespace KConfigEditor;

ConfigSearchLine::ConfigSearchLine( QWidget *parent )
    : KConfigEditorSearchLine( parent )
{
}


bool ConfigSearchLine::itemMatches( const QListViewItem *item, const QString &s ) const
{
    const ConfItem *citem = dynamic_cast<const ConfItem*>( item );
    if ( citem && citem->type() == ConfItem::Group ) {
        GroupToken *token = static_cast<const GroupItem*>( citem )->group();
        if ( token && token->entryContaining( s ) )
            return true;
    }
    return KConfigEditorSearchLine::itemMatches( item, s );
}

#include "configsearchline.moc"
