/**
 * gnomeapp.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef GNOMEAPP_H
#define GNOMEAPP_H

#include <qthread.h>
#include <qwaitcondition.h>
#include <qevent.h>
#include <qdict.h>

namespace KConfigEditor
{
    class GNOMESubsystem;
    class GroupToken;
    class EntryToken;

#define  DoneParsingEventId (QEvent::User + 100)
    class DoneParsingEvent : public QCustomEvent
    {
    public:
        DoneParsingEvent()
            : QCustomEvent(DoneParsingEventId)
        {}
    };

#define  DoneSavingEventId (QEvent::User + 101)
    class DoneSavingEvent : public QCustomEvent
    {
    public:
        DoneSavingEvent()
            : QCustomEvent(DoneSavingEventId)
        {}
    };

    class GNOMEApp : public QThread
    {
    public:
        enum Operation {
            None,
            Parse,
            Save
        };
    public:
        GNOMEApp( GNOMESubsystem *parent );

        void newTopLevelItem( const QString &name );
        void parse();
        void save( const QDict<EntryToken> &entries );
        void saveToken( EntryToken *token );
    protected:
        void run();

    protected:
        void addDir( GroupToken *token );
        void saveEntries();
    private:
        GNOMESubsystem *m_receiver;
        Operation       m_operation;
        void *m_client;
        QWaitCondition m_condition;
        QDict<EntryToken> m_entries;
    };
}

#endif
