/**
 * gnomesubsystem.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#include "gnomesubsystem.h"

#include "grouptoken.h"
#include "configurationview.h"
#include "progressmanager.h"

#include "gnomeapp.h"

#include <kdebug.h>
#include <qvariant.h>

using namespace KConfigEditor;

GNOMESubsystem::GNOMESubsystem( QObject *parent )
    : Subsystem( parent ), m_view( 0 ), m_doneParsing( false ), m_parseRequest( true )
{
    m_app = new GNOMEApp( this );
}

void GNOMESubsystem::setValue( const KURL &, const QVariant & )
{

}

void GNOMESubsystem::parse( ConfigurationView *view )
{
    progressItem()->setProgress( 1 );
    m_view = view;
    m_app->start();
    progressItem()->setProgress( 10 );
    m_app->parse();

    if ( !m_doneParsing ) {
        m_parseRequest = true;
        return;
    } else {
        progressItem()->setProgress( 50 );
        startAttaching();
        m_parseRequest = false;
    }
}

void GNOMESubsystem::saveConfig( GroupToken *token )
{
    while ( token && !token->isTopLevel() ) {
        token = token->parent();
    }
    QDict<EntryToken> &entries = token->modifiedEntries();
    m_app->save( entries );
}

void GNOMESubsystem::customEvent( QCustomEvent *e )
{
    switch ( e->type() ) {
    case DoneParsingEventId:
        m_doneParsing = true;
        if ( m_parseRequest ) {
            startAttaching();
            m_parseRequest = false;
        }
        break;
    case DoneSavingEventId:
        //QDictIterator<GroupToken> itr( m_topLevelGroup );
        //while ( itr.current() ) {
        //itr.current()->prunePendingChanges();
        //}
        break;
    default:
        break;
    }
}

GroupToken *GNOMESubsystem::createTopLevelToken( const QString &name )
{
    GroupToken *token = new GroupToken( protocol(), name );
    token->propagateChanges( false );
    m_topLevelGroup.insert( token->url().url(), token );
    return token;
}

void GNOMESubsystem::startAttaching()
{
    progressItem()->setProgress( 50 );
    m_view->triggerUpdate();
    GroupToken *group = 0;
    QDictIterator<GroupToken> itr( m_topLevelGroup );
    while ( ( group = itr.current() ) ) {
        attachGroup( group );
        ++itr;
    }
    progressItem()->setComplete();
    emit parsingFinished( this );
}

void GNOMESubsystem::attachGroup( GroupToken *token )
{
    token->attach( m_view );

    QDict<GroupToken> &gentries = token->childGroups();
    QDictIterator<GroupToken> itr( gentries );
    while ( itr.current() ) {
        attachGroup( itr.current() );
        ++itr;
    }
}

void GNOMESubsystem::saveToken( EntryToken *token )
{
    m_app->saveToken( token );
}

#include "gnomesubsystem.moc"
