/*
 *   Copyright (C) 2003 Ole Behrmann <obehrmann@hbg-bremen.de> *
 *   Copyright (C) 2003 Christoph Thielecke <crissi99@gmx.de> *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 */

#include "useradmin.h"
#include <kpushbutton.h>
#include <qstring.h>

#ifndef UserAdmin_EDIT_H
#define UserAdmin_EDIT_H

#include "useradminbaseadduser.h"


/**
 * @short class for editing users
 * @author Ole Behrmann <obehrmann@hbg-bremen.de>
 * @author Christoph Thielecke <crissi99@gmx.de>
*/
class UserAdminEdit : public UserAdminBaseAddUser {
    Q_OBJECT

public:

    /*
     *Default Constructor
     *@param url_system_passwd_file system password file
     *@param url_system_group_file system group file
     *@param pCurrent currently selected user
     */
    UserAdminEdit(QString url_system_passwd_file, QString url_system_group_file, QListViewItem *pCurrent);

    /**
    * Default Destructor
    */
    ~UserAdminEdit();

    KLineEditDlg *dialog1, *dialog2, *dialog3, *dialog4;

    QProcess *prcEdit;
    QListViewItem *itm;

protected:
    KPushButton *chPassBtn;
    QString login;

public slots:
    void slotEditAll();
    void slotAbort();
    void slotClosed();

    void slotEnAcc();
    void slotEnTime();
    void slotEnRatio();

    //ip slots
    void slotCliIpAcc();
    void slotCliIpAccAdd();
    void slotCliIpAccRem();//09.04

    void slotCliIpDen();
    void slotCliIpDenAdd();
    void slotCliIpDenRem();//09.04

    void slotLocIpAcc();
    void slotLocIpAccAdd();
    void slotLocIpAccRem();//09.04

    void slotLocIpDen();
    void slotLocIpDenAdd();
    void slotLocIpDenRem();//09.04

    void slotEnBand();
    void slotEnBandwFiles();
    void slotEnBandwSize();
    void slotEnBandwUp();
    void slotEnBandwDown();
    void slotEnBandwConn();

    void slotResetBand();

protected slots:
    void slotChPass();

signals:
    void editDialogClosed();


};

#endif
