/*
 *  Copyright (C) 2003 Crissi <crissi99@gmx.de>
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                   *
 */

#include "useradminpref.h"

UserAdminPref::UserAdminPref() : UserAdminBasePref()
{
   /*
    * ... maybe we should user global variables from other class or sync
    * before read from config file
    */

	 setMinimumSize(sizeHint());

   // set config file
   config = new KConfig("kcmpureftpdUseradminrc",false,false);
   loadConfig();
}
UserAdminPref::~UserAdminPref()
{

}

/*
 * loads config file (same as in other class)
 */
void UserAdminPref::loadConfig(){
   config->setGroup("SystemPaths");
   urlSystemGroupFile->setURL(config->readEntry("System Group File","/etc/group"));
   urlSystemPasswdFile->setURL(config->readEntry("System Password File","/etc/passwd"));
   checkSystem->setChecked(config->readBoolEntry("Use Standard System files Paths",true));
   slotSystemChanged();

   config->setGroup("PureftpdPaths");
   checkPureftpdFiles->setChecked(config->readBoolEntry("Use Standard Pureftpd files Paths",true));
   urlPureftpdPasswdFile->setURL(config->readEntry("Pureftpd Password File","/etc/pure-ftpd/pureftpd.passwd"));
   urlPureftpdGroupFile->setURL(config->readEntry("Pureftpd Group File","/etc/pure-ftpd/pureftpd.group"));
   urlPureftpdDatabaseFile->setURL(config->readEntry("Pureftpd Database File","/etc/pure-ftpd/pureftpd.pdb"));
   slotFilesChanged();

   config->setGroup("Notify");

   checkNotify->setChecked(config->readBoolEntry("Use Standard Notify",true));
   
   if (config->readBoolEntry("Notify on user add",true))
      radioNotifyUserAddYes->setChecked(true);
   else
      radioNotifyUserAddNo->setChecked(true);

   if (config->readBoolEntry("Notify on user modify",true))
      radioNotifyUserModifyYes->setChecked(true);
   else
      radioNotifyUserModifyNo->setChecked(true);

   if (config->readBoolEntry("Notify on user del",true))
      radioNotifyUserDelYes->setChecked(true);
   else
      radioNotifyUserDelNo->setChecked(true);
   slotNotifyChanged();


   config->setGroup("Clean");

   checkClean->setChecked(config->readBoolEntry("Use Standard Clean Up",true));

   if (config->readBoolEntry("Clean on user add",true))
      radioClearUserAddYes->setChecked(true);
   else
      radioClearUserAddNo->setChecked(true);

   if (config->readBoolEntry("Clean on user edit",true))
      radioClearUserEditYes->setChecked(true);
   else
      radioClearUserEditNo->setChecked(true);

   slotCleanChanged();

}


/*
 * save config to config file
 */
void UserAdminPref::saveConfig()
{
   // set path group
   config->setGroup("SystemPaths");

   // set system group file, if empty field -> /etc/group
   if (!urlSystemGroupFile->url().isEmpty())
      config->writeEntry("System Group File",urlSystemGroupFile->url());
   else
      config->writeEntry("System Group File","/etc/group");

   // set system passwd file, if empty field -> /etc/passwd
   if (!urlSystemPasswdFile->url().isEmpty())
      config->writeEntry("System Password File",urlSystemPasswdFile->url());
   else
      config->writeEntry("System Password File","/etc/passwd");

   // set standard system paths
   config->writeEntry("Use Standard System files Paths",checkSystem->isChecked());

   // set PureftpdPaths group
   config->setGroup("PureftpdPaths");
   config->writeEntry("Use Standard Pureftpd files Paths",checkPureftpdFiles->isChecked());

   // set pureftpd passwd file, if empty field ->  /etc/pure-ftpd/pureftpd.passwd
   if (!urlPureftpdPasswdFile->url().isEmpty())
      config->writeEntry("Pureftpd Password File",urlPureftpdPasswdFile->url());
   else
      config->writeEntry("Pureftpd Password File","/etc/pure-ftpd/pureftpd.passwd");

   // set pureftpd group file, if empty field ->  /etc/pure-ftpd/pureftpd.group
   if (!urlPureftpdGroupFile->url().isEmpty())
      config->writeEntry("Pureftpd Group File",urlPureftpdGroupFile->url());
   else
      config->writeEntry("Pureftpd Group File","/etc/pure-ftpd/pureftpd.group");

   // set pureftpd user database file, if empty field ->  /etc/pure-ftpd/pureftpd.pdb
   if (!urlPureftpdDatabaseFile->url().isEmpty())
      config->writeEntry("Pureftpd Database File",urlPureftpdDatabaseFile->url());
   else
      config->writeEntry("Pureftpd Database File","/etc/pure-ftpd/pureftpd.pdb");

   // set Notify group
   config->setGroup("Notify");

   // set from radiobuttons
   config->writeEntry("Use Standard Notify",checkNotify->isChecked());
   config->writeEntry("Notify on user add",radioNotifyUserAddYes->isChecked());
   config->writeEntry("Notify on user modify",radioNotifyUserModifyYes->isChecked());
   config->writeEntry("Notify on user del",radioNotifyUserDelYes->isChecked());
   
   // set Notify group
   config->setGroup("Clean");
   config->writeEntry("Use Standard Clean Up",checkClean->isChecked());
   config->writeEntry("Clean on user add",radioClearUserAddYes->isChecked());
   config->writeEntry("Clean on user edit",radioClearUserEditYes->isChecked());

   // sync file
   config->sync();

   
}


/*
 * slot for enable/disable system passwd/group url fields
 */
void UserAdminPref::slotSystemChanged()
{
   // if standard -> fields disabled else enabled
   if (checkSystem->isChecked()){
      urlSystemPasswdFile->setEnabled(false);
      urlSystemGroupFile->setEnabled(false);
   }
   else {
      urlSystemPasswdFile->setEnabled(true);
      urlSystemGroupFile->setEnabled(true);
   }

}

/*
 * slot for enable/disable pureftpd passwd/group/database url fields
 */
void UserAdminPref::slotFilesChanged()
{
   // if standard -> fields disabled else enabled
   if (checkPureftpdFiles->isChecked()){
      urlPureftpdPasswdFile->setEnabled(false);
      urlPureftpdGroupFile->setEnabled(false);
      urlPureftpdDatabaseFile->setEnabled(false);
   }
   else {
      urlPureftpdPasswdFile->setEnabled(true);
      urlPureftpdGroupFile->setEnabled(true);
      urlPureftpdDatabaseFile->setEnabled(true);
   }

}

/*
 * slot for enable/disable notify radiobuttons
 */
void UserAdminPref::slotNotifyChanged()
{
   // if standard -> fields disabled else enabled
   if (checkNotify->isChecked()){
      buttonGroupNotifyUserAdd->setEnabled(false);
      buttonGroupNotifyUserModify->setEnabled(false);
      buttonGroupNotifyUserDel->setEnabled(false);
   }
   else {
      buttonGroupNotifyUserAdd->setEnabled(true);
      buttonGroupNotifyUserModify->setEnabled(true);
      buttonGroupNotifyUserDel->setEnabled(true);
   }
}

/*
 * slot for enable/disable clear radiobuttons
 */
void UserAdminPref::slotCleanChanged()
{
   // if standard -> fields disabled else enabled
   if (checkClean->isChecked()){
      buttonGroupClearUserAdd->setEnabled(false);
      buttonGroupClearUserEdit->setEnabled(false);
   }
   else {
      buttonGroupClearUserAdd->setEnabled(true);
      buttonGroupClearUserEdit->setEnabled(true);
   }

}

/*
 * slot for ok button
 */
void UserAdminPref::slotOk()
{                     
   saveConfig();
   close();
}
