/***************************************************************************
                          dive.cpp  -  description
                             -------------------
    begin                : Son Apr 7 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
    version              : $Revision: 1.4 $
    date                 : $Date: 2002/04/13 18:26:56 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "diveprofile.h"
#include "dive.h"



Dive::Dive()
{
    _profile = 0;
}


Dive::Dive( Dive const &rhs )
{
    _number = rhs._number;
    _dateTime = QDateTime( rhs._dateTime );
    _place = QString( rhs._place );
    _duration = rhs._duration;
    _depth = rhs._depth;
    _airConsumption = rhs._airConsumption;
    _waterTemperature = rhs._waterTemperature;
    _buddy = QString( rhs._buddy );
    
    if( rhs._profile )
    {
	_profile = new DiveProfile( *(rhs._profile) );
    }
    else
    {
	_profile = 0;
    }
}


Dive::~Dive()
{
    if( _profile )
	delete _profile;
}




void Dive::setAladinProfileData( unsigned char *data, int len )
{
    if( _profile )
	delete _profile;

    _profile = new DiveProfile();
}


bool Dive::hasProfile( void ) const
{
    if( _profile )
	return true;
    else
	return false;
}
