// Emacs-Mode: -*-C++-*-
/***************************************************************************
                          importdialogaladin.h  -  description
                             -------------------
    begin                : Son Apr 7 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
    version              : $Revision: 1.3 $
    date                 : $Date: 2002/04/12 17:07:47 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IMPORTDIALOGALADIN_H
#define IMPORTDIALOGALADIN_H

#include <qwidget.h>
#include <qptrlist.h>

#include <klistview.h>

#include "importdialogaladingui.h"


// forward declarations
class InterfaceAladin;
class Dive;



//! Dialog for the import of dives from an Aladin Computer
/*! Dialog for the import of dives from an Aladin Computer
 */
class ImportDialogAladin : public ImportDialogAladinGUI {

    Q_OBJECT

public: 
    //! Default Constructor
    ImportDialogAladin( QWidget *parent=0, const char *name=0, 
			bool modal = true );

    //! Default Destructor
    ~ImportDialogAladin();

    //! Function to read out all selected dives
    void getSelectedDives( QPtrList< Dive > &diveList );


public slots:
    //! Slot for the "Cancel"-button
    virtual void slotCancel( void );

    //! Slot for the "Import"-button
    virtual void slotImport( void );

    //! Overloaded exec()-function
    int exec( void );

protected:
    //! Instance of the aladin interface
    InterfaceAladin *_aladin;


    //! KListViewItem for displaying a dive in the ImportDialogAladin
    /*! DiveListViewItem is a private class of class ImportDialogAladin and
      is a KListViewItem. Its purpose is simply to display a dive from
      the aladin computer in the KListView of the Dialog ImportDialogAladin.
    */
    class DiveListViewItem : public KListViewItem {
	
    public:
	//! Contsructor
	DiveListViewItem( const Dive &dive, KListView *parent );

	//! Access to the number of the dive that this item displays
	inline int diveNumber( void ) const;

	//! Overloaded key()-function for better sorting
	virtual QString key( int column, bool ascending ) const;

    protected:
	//! Number of the dive which this item displays
	int _number;
	
    };
};



inline int ImportDialogAladin::DiveListViewItem::diveNumber( void ) const
{ return _number; }


#endif
