// Emacs-Mode: -*-C++-*-
/***************************************************************************
                          kdivemaster.h  -  description
                             -------------------
    begin                : Sam Apr  6 11:25:35 CEST 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDIVEMASTER_H
#define KDIVEMASTER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kmainwindow.h>


// forward declarations
class MainWidget;
class KRecentFilesAction;



//! Base class of KDiveMaster
/*! KDiveMaster provides the main window of the KDiveMaster-Application
 */
class KDiveMaster : public KMainWindow
{

    Q_OBJECT 

public:
    //! Default Constructor
    KDiveMaster(QWidget* parent=0, const char *name=0);

    //! Default Destructor
    ~KDiveMaster();


public slots:
    //! Slot to configure the toolbar(s)
    void slotConfigureToolbars( void );

    //! Slot to apply a new toolbar-config
    void slotNewToolbarConfig( void );

    //! Slot to configure the key bindings
    void slotConfigureKeys( void );

    //! Slot to add a new filename to the List of recent files
    void slotAddRecentFile( const KURL &url );


private:
    //! Function to set up the GUI
    void setupGui( void );

    //! Function to create all actions
    void setupActions( void );


    //! Instance of the class MainWidget
    MainWidget *_mainWidget;

    //! Action for "Recent Files"
    KRecentFilesAction *_recentAction;
};

#endif
