/***************************************************************************
                          mainwidget.cpp  -  description
                             -------------------
    begin                : Sam Apr 6 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
    version              : $Revision: 1.6 $
    date                 : $Date: 2002/04/14 09:24:11 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>

#include <qlayout.h>
#include <qtabwidget.h>
#include <qptrvector.h>
#include <qptrlist.h>

#include "kio/netaccess.h"
#include "kurl.h"
#include "kfiledialog.h"
#include "ktempfile.h"
#include "kmessagebox.h"
#include "kaction.h"

#include "logbook.h"
#include "dive.h"
#include "logbookwidget.h"
#include "importdialogaladin.h"
#include "filemanager.h"
#include "logbooknamedialog.h"
#include "mainwidget.h"



MainWidget::MainWidget( QWidget *parent, const char *name ) 
    : QWidget(parent,name) 
{
    _actionCollection = 0;

    setupGui();

    // initialize vector of open logbooks
    _openLogBooks = new QPtrVector< LogBook >();
    _openLogBooks->setAutoDelete( true );

    // initiallize the dive-clipboard
    _diveClipboard = new QPtrList< Dive >();
    _diveClipboard->setAutoDelete( true );

    openLastLogBooks();
}



MainWidget::~MainWidget()
{
    delete _openLogBooks;
    delete( _diveClipboard );
}



void MainWidget::openLastLogBooks( void )
{
//      LogBookWidget *wdg = new LogBookWidget( this );
//      wdg->setMinimumSize( wdg->sizeHint() );

//      LogBook *book = new LogBook( "Untitled" );

//      wdg->setLogBook( book );
//      _openLogBooks->resize( 1 );
//      _openLogBooks->insert( 0, book );

//      _tabWidget->addTab( wdg, book->name() );
}


void MainWidget::setActionCollection( KActionCollection *actionCollection )
{
    _actionCollection = actionCollection;
    updateActionState();
}


void MainWidget::updateActionState( void )
{
    if( _actionCollection )
    {
	bool enab = (_diveClipboard->count() > 0 && _openLogBooks->count() > 0 );
	_actionCollection->action( "my_edit_paste" )->setEnabled( enab );
	
	enab = (_openLogBooks->count() > 0 );
	_actionCollection->action( "my_edit_name" )->setEnabled( enab );
	_actionCollection->action( "my_file_close" )->setEnabled( enab );
	_actionCollection->action( "my_file_save" )->setEnabled( enab );
	_actionCollection->action( "my_file_saveas" )->setEnabled( enab );
	_actionCollection->action( "my_file_import_aladin" )->setEnabled( enab );

	if( _openLogBooks->count() == 0 )
	{
	    _actionCollection->action( "my_edit_cut" )->setEnabled( false );
	    _actionCollection->action( "my_edit_copy" )->setEnabled( false );
	}
    }
}


/************************************************
 ************************************************/


void MainWidget::slotSelectionChanged( int numberOfSelectedDives )
{
    if( _actionCollection )
    {
	bool enab = ( numberOfSelectedDives > 0 );
	_actionCollection->action( "my_edit_cut" )->setEnabled( enab );
	_actionCollection->action( "my_edit_copy" )->setEnabled( enab );    
    }
}


void MainWidget::slotFileNew( void )
{
    LogBookNameDialog *diag = new LogBookNameDialog( this );

    if( diag->exec() == QDialog::Accepted )
    {
	LogBook *logBook = new LogBook( diag->name() );

	// create a new tab for the new logbook
	LogBookWidget *logBookWdg = new LogBookWidget( this );
	logBookWdg->setMinimumSize( logBookWdg->sizeHint() );
	connect( logBookWdg, SIGNAL(signalSelectionChanged(int)),
		 this, SLOT(slotSelectionChanged(int)) );
	logBookWdg->setLogBook( logBook );
	
	int size = _openLogBooks->count();
	_openLogBooks->resize( size + 1 );
	_openLogBooks->insert( size, logBook );
	
	_tabWidget->addTab( logBookWdg, logBook->name() );
	_tabWidget->showPage( logBookWdg );
    }

    updateActionState();
}


void MainWidget::slotFileOpen( void )
{
    KURL openURL = KFileDialog::getOpenURL();

    slotFileOpenUrl( openURL );
    updateActionState();
}



void MainWidget::slotFileOpenRecent( const KURL& openURL )
{
    slotFileOpenUrl( openURL );
    updateActionState();
}


void MainWidget::slotFileSave( void )
{
    if( _openLogBooks->at( _tabWidget->currentPageIndex() )->url().isEmpty())
    {
	slotFileSaveAs();
    }
    else
    {
	slotFileSaveUrl( _openLogBooks->at( _tabWidget->currentPageIndex() )->url() );
    }

    updateActionState();
}

    
void MainWidget::slotFileSaveAs( void )
{
    KURL saveURL = KFileDialog::getSaveURL();

    slotFileSaveUrl( saveURL );
    updateActionState();
}




void MainWidget::slotFileOpenUrl( const KURL &openURL )
{
    if( openURL.isEmpty() )
	return;

    QString tmpFile;
    if( KIO::NetAccess::download( openURL, tmpFile ) )
    {
	LogBook *logBook = new LogBook;

	FileManager *fileManager = new FileManager;
	if( fileManager->readLogBook( tmpFile, logBook ) )
	{
	    logBook->setUrl( openURL );

	    // create a new tab for the opened logbook
	    LogBookWidget *logBookWdg = new LogBookWidget( this );
	    logBookWdg->setMinimumSize( logBookWdg->sizeHint() );
	    connect( logBookWdg, SIGNAL(signalSelectionChanged(int)),
		     this, SLOT(slotSelectionChanged(int)) );
	    logBookWdg->setLogBook( logBook );

	    int size = _openLogBooks->count();
	    _openLogBooks->resize( size + 1 );
	    _openLogBooks->insert( size, logBook );

	    _tabWidget->addTab( logBookWdg, logBook->name() );
	    _tabWidget->showPage( logBookWdg );
	    
	    // add URL to recent URLs
	    emit( signalNewRecentFile( openURL ) );
	}
	else
	{
	    delete logBook;
	}

	KIO::NetAccess::removeTempFile( tmpFile );
    }
}


void MainWidget::slotFileSaveUrl( const KURL &saveURL )
{
    if( saveURL.isEmpty() )
	return;

    KTempFile *tempFile = new KTempFile;

    if( tempFile->status() != 0 )
    {
	QString msg;
	msg.sprintf( "Could not create a temporary file for saving your logbook." );
	KMessageBox::sorry( this, msg );
	
	tempFile->unlink();
	delete tempFile;
	return;
    }

    FileManager *fileManager = new FileManager;

    if( fileManager->writeLogBook( tempFile->name(), _openLogBooks->at( _tabWidget->currentPageIndex() ) ) )
    {
	if( ! KIO::NetAccess::upload( tempFile->name(), saveURL ) )
	{
	    QString msg;
	    msg.sprintf( "Could not create a temporary file for saving your logbook." );
	    KMessageBox::sorry( this, msg );
 	}
	else
	{
	    _openLogBooks->at( _tabWidget->currentPageIndex() )->setUrl( saveURL );
	}
    }

    tempFile->unlink();
    delete tempFile;
    delete fileManager;
}



void MainWidget::slotFileClose( void )
{
    int index = _tabWidget->currentPageIndex();

    _openLogBooks->remove( index );

    // shrink vector _openLogBooks
    for( unsigned int i = index; i < _openLogBooks->size() - 1; i++ )
    {
	_openLogBooks->insert( i, _openLogBooks->take( i + 1 ) );
    }
    _openLogBooks->resize( _openLogBooks->size() - 1 );

    QWidget *removeMe = _tabWidget->page( index );
    _tabWidget->removePage( removeMe );
    delete removeMe;

    updateActionState();
}


void MainWidget::slotImportAladin( void )
{
    ImportDialogAladin *diag = new ImportDialogAladin();

    if( diag->exec() == QDialog::Accepted )
    {
	QPtrList< Dive > diveList;
	diveList.setAutoDelete( false );

	diag->getSelectedDives( diveList );
	cout << "new dives: " << diveList.count() << endl;

	// Merge new dives into current LogBook
	LogBook *currentLogBook = _openLogBooks->at( _tabWidget->currentPageIndex() );
	

	for( Dive *newDive = diveList.first();
	     newDive;
	     newDive = diveList.next() )
	{
	    cout << "dive-no.: " << newDive->number() << endl;
	    currentLogBook->inSort( newDive );
	}

	// adjust the numbers of the dives
	int number = 1;
	for( Dive *dive = currentLogBook->first();
	     dive;
	     dive = currentLogBook->next() )
	{
	    dive->setNumber( number++ );
	}

	((LogBookWidget *) _tabWidget->currentPage())->setLogBook( currentLogBook );
    }

}


void MainWidget::slotEditLogbookName( void )
{
    int index = _tabWidget->currentPageIndex();
    QString name = _tabWidget->tabLabel( _tabWidget->page( index ) );

    LogBookNameDialog *diag = new LogBookNameDialog( name, this );

    if( diag->exec() == QDialog::Accepted )
    {
	name = diag->name();
	_openLogBooks->at( index )->setName( name );
	_tabWidget->setTabLabel( _tabWidget->page( index ), name );
    }
}


void MainWidget::slotEditCutDives( void )
{
    int index = _tabWidget->currentPageIndex();
    LogBook *logBook = _openLogBooks->at( index );

    QPtrList< int > selectedDives;
    selectedDives.setAutoDelete( true );

    // get a list of the numbers of the currently selected dives
    ((LogBookWidget *) _tabWidget->page( index ))->getSelectedDives( selectedDives );

    // delete all selected dives by their number
    for( int *diveNumber = selectedDives.first();
	 diveNumber;
	 diveNumber = selectedDives.next() )
    {
	logBook->deleteDive( *diveNumber );
    }
    
    // re-set the logbook to display the result of the deletion
    ((LogBookWidget *) _tabWidget->page( index ))->setLogBook( logBook );    
}



void MainWidget::slotEditCopyDives( void )
{
    int index = _tabWidget->currentPageIndex();
    LogBook *logBook = _openLogBooks->at( index );

    QPtrList< int > selectedDives;
    selectedDives.setAutoDelete( true );

    // get a list of the numbers of the currently selected dives
    ((LogBookWidget *) _tabWidget->page( index ))->getSelectedDives( selectedDives );

    // copy all dives to the clipboard
    Dive const *item;
    _diveClipboard->clear();
    for( int *diveNumber = selectedDives.first();
	 diveNumber;
	 diveNumber = selectedDives.next() )
    {
	item = logBook->getDive( *diveNumber );
	if( item )
	{
	    _diveClipboard->append( new Dive( *item ) );
	}
    }

    updateActionState();
}



void MainWidget::slotEditPasteDives( void )
{
    // Merge new dives into current LogBook
    LogBook *currentLogBook = _openLogBooks->at( _tabWidget->currentPageIndex() );

    Dive *hlp;
    for( Dive *copyDive = _diveClipboard->first();
	 copyDive;
	 copyDive = _diveClipboard->next() )
    {
	hlp = new Dive( *copyDive );
	currentLogBook->inSort( hlp );
    }
    
    // adjust the numbers of the dives
    int number = 1;
    for( Dive *dive = currentLogBook->first();
	 dive;
	 dive = currentLogBook->next() )
    {
	dive->setNumber( number++ );
    }
    
    ((LogBookWidget *) _tabWidget->currentPage())->setLogBook( currentLogBook );    
}



void MainWidget::slotCurrentTabChanged( QWidget *page )
{
    // update the sate of copy / cut actions according to the selection
    // in the new tab
    slotSelectionChanged( ((LogBookWidget *)page)->getNumberOfSelectedDives() );
}



void MainWidget::setupGui( void )
{
    // Create TabWidget
    _tabWidget = new QTabWidget( this );
    connect( _tabWidget, SIGNAL(currentChanged(QWidget *)),
	     this, SLOT(slotCurrentTabChanged(QWidget *)) );
    
    // Layout
    QVBoxLayout *mainLayout = new QVBoxLayout( this );
    mainLayout->addWidget( _tabWidget );
}
