/***************************************************************************
                          berechnungen.cpp  -  description
                             -------------------
    begin                : Die Jan 21 2003
    copyright            : (C) 2003 by Ronny Kissing
    email                : ronny.kissing@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "berechnungen.h"

int Prim[348514];
int Pram[5000001];
int Faktor1, Faktor2;
int Schluessel_bekannt = 0;
int AnzahlSchritte;
int Fehl = 0;
int g;
int Fortschritt = 0;



secretKey skey;


//Variablen fr das Dekodieren

int PrivaterSchluessel;
QString Meldung;
bool checkt;
int Plainergebnis;




/** Funktion zum Berechnen des grten gemeinsamen Teilers */
int gcd(int a, int b)
{


    int temp;
    int Schritte = 0;


    //Wenn a < b werden die Zahlen vertauscht, so das nichts kleiner 0 enstehen kann
    if ( a < b)
    {
        temp = a;
        a = b;
        b = temp;
    }

    //Die eigentliche Schleife zum Berechnen des GCD
    while( (temp = a % b) != 0)
    {
        a = b;
        b = temp;
        Schritte++;
    }

    AnzahlSchritte = Schritte;

    return b;
}



//Kodierungsfunktion
int EncodeRSA(int k, int n, int p)
{
    long long int temp = 1;

    for(int rum = 1; rum <= k; rum++)
    {
      temp = (temp * p) % n;
    }

    return temp;
}



//Funktion zum Faktorisieren einer Zahl in zwei Primzahlen
int faktorisiere(int Zahl)
{

    int index = 0;


    while(Zahl > Prim[index])
    {
        if((Zahl % Prim[index]) == 0)
        {
          Faktor1 = Prim[index];
          Faktor2 = Zahl / Faktor1;
          break;
        }
        else
        index++;
    }

   return 1;
}



/** Initialisieren der Primzahlen fr die Primfaktorzerlegung */
int InitialPrimzahl()
{

return 0;  
}


//Bilden von Phi(n)
int phi_von_n()
{
  int phi;

     phi = (Faktor1 - 1) * (Faktor2 - 1);

     return phi;
}


//Primzahltest

bool IsPrimZahl(int Zahl)
{
  for(int t=1;t<20001;t++)
  {
    if(Zahl == Prim[t]) return true;
  }
  return false;
}


//Funktion zum Dekodieren

void DekodierenRSA(int Schluessel, int Modul, int Ciferwert)
{

 long long int temp = 1;
 temp = Modul;
 temp = Ciferwert;

  faktorisiere(Modul);
  
  if(IsPrimZahl(Faktor1) && IsPrimZahl(Faktor2))
  {
 
        //Bilden von Phi_von_n und der Struktur skey zuweisen
        skey.phi_n[0] = phi_von_n();
        if(gcd(skey.phi_n[0], Schluessel)!=1)
        {
          Fehl = 5;
          return;
        }

        // Lsungsstrucktur wird initialisiert
        skey.phi_n[1] = skey.k[0] = Schluessel;

        int i = 0;

        //Schleife um die Schritte zu zhlen
        while(i < 10)
        {
          skey.a[i] = (int)(skey.phi_n[i]/skey.k[i]);
          skey.phi_n[i+2] = skey.k[i+1] = skey.b[i] = skey.phi_n[i]-skey.a[i]*skey.k[i];
          if(skey.b[i] == 1) break;
          i++;
        }



        //Eigentliche Berechnung
        switch(i)
        {

          case 0:
          {
            Meldung = "Es war 1 Schritt ntig";

            // Bei zwei Schritten ist es noch simpel
            g = skey.phi_n[0] - skey.k[0];
            cout << skey.phi_n[0] << endl << skey.k[0] << endl;
              //if(g<0)g = mod(g,skey.phi_n[0]);

            /*if(gcd(g,skey.phi_n[0])!=1)
            {
              Fehl = 5;
              return;
            } */
            
             // Fehl = 7;            

            //Alle Werte setzen und als bekannter Privater Schlssel ausgeben!!
            PrivaterSchluessel = abs(g);
            checkt = true;
            Schluessel_bekannt = 1;

            AnzahlSchritte = 1;
            break;
          }

          case 1:
          {
            Meldung = "Es waren 2 Schritte ntig";

            // Bei zwei Schritten ist es noch simpel
            g = skey.a[0]*skey.a[1]+1;

            if(g<0)g = mod(g,skey.phi_n[0]);

            if(gcd(g,skey.phi_n[0])!=1)
            {
              Fehl = 5;
              return;
            } 

            //Alle Werte setzen und als bekannter Privater Schlssel ausgeben!!
            PrivaterSchluessel = abs(g);
            checkt = true;
            Schluessel_bekannt = 1;
            cout << g << endl;
            AnzahlSchritte = 2;           
            break;
          }


          case 2:
          {
            Meldung = "Es waren 3 Schritte ntig";


            // Im Falle, das drei Schritte ntig waren
            int a = skey.a[0], a1=-skey.a[1], a2=-skey.a[2];

            g = -(a+a2+a*a1*a2);
            if(g<0)g = mod(g,skey.phi_n[0]);

            if(gcd(g,skey.phi_n[0])!=1)
            {
              Fehl = 5;
              return;
            } 

            PrivaterSchluessel = abs(g);
            checkt = true;
            Schluessel_bekannt = 1;

            AnzahlSchritte = 3;

            break;
          }


          case 3:
          {
            Meldung = "Es waren 4 Schritte ntig";

            // Bei vier Schritten siehts schon bse aus!
            int a =skey.a[0], a1=skey.a[1], a2=skey.a[2], a3=skey.a[3];
            g = a2*a3+a*(a1*a2*a3+a1+a3)+1;

            if(g<0)g = mod(g,skey.phi_n[0]);

            if(gcd(g,skey.phi_n[0])!=1)
            {
              Fehl = 5;
              return;
            } 

            PrivaterSchluessel = abs(g);
            checkt = true;
            Schluessel_bekannt = 1;

            AnzahlSchritte = 4;
            
            break;
          }

          case 4:
          {
            Meldung = "Es waren 5 Schritte ntig";

            // Bei fnf Schritten gehts gar nich mehr ;b
            int a =-skey.a[0], a1=-skey.a[1], a2=-skey.a[2], a3=-skey.a[3], a4=-skey.a[4];

//            g = (a+a2+a*a1*a2)*(a3-1)+(a-1)*a4;

            g = a+a2+a*a1*a2+a4+a*a1*a4+a*a3*a4+a2*a3*a4+a*a1*a2*a3*a4;
            
            if(g<0)g = mod(g,skey.phi_n[0]);

                
            if(gcd(g,skey.phi_n[0])!=1)
            {
              Fehl = 5;
              return;
            } 

              PrivaterSchluessel = abs(g);
              checkt = true;
              Schluessel_bekannt = 1;

              AnzahlSchritte = 5;
                       
              break;
            }

            case 5:
            {
              Meldung = "Es waren 6 Schritte ntig";

            // Bei sechs Schritten gehts gar nich mehr ;b
            int a =skey.a[0], a1=skey.a[1], a2=skey.a[2], a3=skey.a[3], a4=skey.a[4], a5=skey.a[5];
            g = 1+a*a1+a*a3+a2*a3+a*a1*a2*a3+a*a5+a2*a5+a*a1*a2*a5+a4*a5+a*a1*a4*a5+a*a3*a4*a5+a2*a3*a4*a5+a*a1*a2*a3*a4*a5;
            if(g<0)g = mod(g,skey.phi_n[0]);

            if(gcd(g,skey.phi_n[0])!=1)
            {
              Fehl = 5;
              return;
            } 

            PrivaterSchluessel = abs(g);
            checkt = true;
            Schluessel_bekannt = 1;

            AnzahlSchritte = 6;
            
            break;
            }

          case 6:
            if(Fehl != 5)
              Fehl = 7;

            AnzahlSchritte = 7;
            
            break;
            
          case 7:
            if(Fehl != 5)
              Fehl = 7;
            break;

          case 8:
            if(Fehl != 5)
              Fehl = 7;            
            break;

          case 9:
            if(Fehl != 5)
              Fehl = 7;            
            break;
            
            
          default:
            break;
          
        }
    }
    else
      Fehl = 6;

      
}




//Berechnen der Modulo Rechnung
int mod(int Zahl, int Modul)
{
    Zahl %= Modul;
    return Zahl;
}
