/***************************************************************************
                          kwappen.h  -  description
                             -------------------
    begin                : Sam Okt 20 14:11:56 CEST 2001
    copyright            : (C) 2001 by Jens Schulz
    email                : jschulz-lcs@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWAPPEN_H
#define KWAPPEN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <kapp.h>
#include <kmainwindow.h>
#include <kmenubar.h>
#include <kpopupmenu.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kstdaction.h>
#include <kaboutdata.h>
#include <kglobal.h>
#include <kstddirs.h>

#include <qfont.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <qobject.h>
#include <qpainter.h>
#include <qpoint.h>
#include <qpushbutton.h>
#include <qbttngrp.h>
#include <qstring.h>
#include <qimage.h>
#include <qmessagebox.h>
#include <qtimer.h>
#include <qdialog.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qkeycode.h>

/** Kwappen is the base class of the project */
class Kwappen : public KMainWindow
{
  Q_OBJECT
  QPixmap buffer;
  QPixmap pixmap;
  QImage picture;
  QTimer *timer;

  char start;
  char turm[12][4];   // 12 rows, 4 columns
  char turmcpy[12][4];
  char stein1, steinx, steiny, stein1old, stein2old, spalte1;
  char own_row, own_col, own_color, comp_row, comp_col, comp_color;
  char found;
  char langswap;  // flag for language swap
  char swap;
  char reversecolumn;
  char auto_sh_delay;
  char autoshitem;

  char zeitstr[50];  // second string

  void turm_farbe(char);
  void draw_turmset();
  void set_computer();
  void turm_shrink();
  void ende_check();
  void eatblank();
  void vier_shrink();
  void column_shrink();
  void turm_copy();
  void turm_shrinking();
  void turm_reduce();
  void turm_reverse(char);
  void setTextBox(QPainter*);

  int random_color();
  int random_column();

  protected:
  void paintEvent(QPaintEvent*);
  void mousePressEvent(QMouseEvent*);
  void keyPressEvent(QKeyEvent*);
  void resizeEvent(QResizeEvent*);

  public:
  int xpos, ypos;
  int sekunden;
  char status;

  KMenuBar* menu;
  KPopupMenu* datei;
  KPopupMenu* options;
  QPushButton* swapbutton;
  QPushButton* rotatebutton1;
  QPushButton* rotatebutton2;
  QPushButton* rotatebutton3;
  QPushButton* rotatebutton4;
  QButtonGroup* bgroup;

  void topWA(KApplication*);
  void set_random();
  void loadOptions();

  public slots:
  void newGame();
  void countSeconds();
  void swapComp();
  void rotateColumns(int);
  void showHighscore();
  void clearHighscore();
  void autoShrink();
  void saveOptions();
  void heraldry();

  public:
    void start_turm();
    /** constructor */
    Kwappen();
};

class Highscore : public QDialog
{ Q_OBJECT

  QPushButton* okButton;
  QListBox* listBox;

  protected:
  void paintEvent(QPaintEvent*);

  public slots:
  void closeHighscore();

  public:

  int score[51];

  void lookHighscore();
  void loadHighscore();
  char testHighscore();

  Highscore(QWidget* parent, const char* name = 0, WFlags f = 0);
  ~Highscore(){} };

class HighscoreEdit : public QDialog
{ Q_OBJECT

  QLineEdit* highscoreentry;
  QPushButton* highButton;
  char playerName[50];

  protected:
  void paintEvent(QPaintEvent*);

  public slots:
  void getHighscore();

  public:

  int sec;
  char position;
  char rank;
  void writeHighscore();

   HighscoreEdit(QWidget* parent, const char* name = 0, WFlags f = 0);
  ~HighscoreEdit(){} };

class Heraldry : public QDialog
{ Q_OBJECT

  QListBox* heraldryListBox;
  QPushButton* heraldryButton;

  protected:
  void paintEvent(QPaintEvent*);

  public slots:
  void closeHeraldry();

  public:

  Heraldry(QWidget* parent, const char* name = 0, WFlags f = 0);
  ~Heraldry(){} };

#endif
