/*
 *
 * Copyright (C) 2002 Zsolt Rizsanyi <rizsanyi@myrealbox.com>
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by 
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef HAVE_XDPMS
# define QT_CLEAN_NAMESPACE
#include <kdebug.h>
# include <qwindowdefs.h>
# include <X11/Xlib.h>
extern "C" {
# include <X11/extensions/dpms.h>
}
#endif

#include "dpmscontrol.h"

bool DpmsControl::getDpmsStatus()
{
#ifdef HAVE_XDPMS
    Display *displ = qt_xdisplay();
    int nothing;
    if (DPMSQueryExtension(displ, &nothing, &nothing) && DPMSCapable(displ)) {
	CARD16 power_level;
	BOOL state;
	if (DPMSInfo(displ, &power_level, &state)) {
	    return state;
	}
    }
#endif
    return false;
}

bool DpmsControl::enableDpms(bool enable)
{
#ifdef HAVE_XDPMS
    Display *displ = qt_xdisplay();
    int nothing;
    if (DPMSQueryExtension(displ, &nothing, &nothing) && DPMSCapable(displ)) {
	Status ret;
	if (enable)
	    ret = DPMSEnable(displ);
	else
	    ret = DPMSDisable(displ);
	if (ret) {
	    CARD16 power_level;
	    BOOL state;
	    if (DPMSInfo(displ, &power_level, &state)) {
		return enable == state;
	    }
	} else {
	    kdDebug() << "dpms not available?!" << endl;
	    return false;
	}
    }
#else
    kdDebug() << "Trying to "<< (enable?"enable":"disable") <<
	" dpms, but not compiled in" << endl;
#endif
    return false;
}

bool DpmsControl::disableDpms()
{
    return DpmsControl::enableDpms(false);
}
