/* 
   Copyright (c) 2002 Malte Starostik <malte@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

// $Id: channelioxawtv.h,v 1.6 2004/03/23 22:00:22 dziegel Exp $

#ifndef CHANNELIOXAWTV_H
#define CHANNELIOXAWTV_H

#include "channelio.h"

class ChannelIOFormatXawtv : public KdetvChannelPlugin
{
public:
	ChannelIOFormatXawtv(Kdetv *ktv, QObject *parent = 0L, const char *name = 0L);

	virtual bool load(ChannelStore *store, const QString &filename, const QString& fmt);
	virtual bool save(ChannelStore* store, QIODevice* file, const QString& fmt);

private:
	struct ChannelInfo;

	static void setFrequencyTable( const QString& name );
	static unsigned long channelToFrequency( const QString& name );
};

#endif // CHANNELIOXAWTV_H

// vim: ts=4 sw=4 noet
