// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __KDETVV4L_PLUGIN_H
#define __KDETVV4L_PLUGIN_H

#include <kdetvsrcplugin.h>
#include <qmutex.h>
#include <qmap.h>
#include <qtimer.h>

#include "v4lplugincfg.h"

#include "qvideostream.h"

class V4LDev;
class V4LGrabber;
class OverlayController;

/**
 * Video source plugin for Video4Linux.
 */
class KdetvV4L : public KdetvSourcePlugin
{
    Q_OBJECT

public:
    KdetvV4L(Kdetv *ktv, QWidget *parent = 0, const char* name = 0);
    virtual ~KdetvV4L();

    /**
     * To get various values.
     */
    virtual int brightness();
    virtual int colour();
    virtual int hue();
    virtual int contrast();
    virtual int whiteness();
    virtual int frequency();
    virtual bool muted();
    virtual bool isTuner();
    virtual int signal();
    virtual QColor colourKey();

    virtual const QStringList& broadcastedAudioModes();
    virtual const QString&     defaultAudioMode();

    virtual int probeDevices();

    virtual bool videoPlaying() const;


public slots:
    /**
     * Sets the device to use.
     */
    virtual int setDevice( const QString &dev );

    /**
     * Sets the source to use.
     */
    virtual int setSource( const QString &src );

    /**
     * Sets the tuner mode.
     */
    virtual int setEncoding( const QString &encoding );

    /**
     * Sets the current current channel.
     */
    virtual void setFrequency( int freq );

    /**
     * Mutes the sound.
     */
    virtual void setMuted( bool muted );

    virtual int setAudioMode( const QString& audioMode );

    virtual void setBrightness(int val);
    virtual void setColour(int val);
    virtual void setHue(int val);
    virtual void setContrast(int val);
    virtual void setWhiteness(int val);

    virtual int startVideo();
    virtual int stopVideo();
    
    virtual int setVideoDesktop(bool on);
    virtual bool canVideoDesktop() const;

    virtual bool canGrabStill() const;
    virtual bool grabStill( QImage *pix );

    virtual QWidget *configWidget(QWidget*, const char *);
    virtual void saveConfig();

    virtual void setFullscreen(bool);


private:
    int getGrabFormat(int qvsMethod);

    QWidget *_w;
    QWidget *_dtReg;
    QWidget *_winReg;
    int _wReg, _hReg;
    V4LDev *dev;
    V4LGrabber *g;
    QMap<QString,QString> _devNames;
    bool _probed;
    QVideoStream *_vs;
    QString _currentDev;
    OverlayController *_overlayController;
    bool _capturing;
    V4LPluginCfg *_cfgWidget;
    int _gsn;  // grabber sequence number

    QSize setScreenResolution(const QSize&);
    QSize _previousSize;

    // Config options
    bool _autoConfig;
    int  _qvsMethod;
    bool _useOverlay;
    bool _dvbs;
    bool _mirror;
    int  _frameRate;
    bool _changeRes;

    
private slots:
    void viewMoved();
    void viewResized();
    void repaintScreen();
    void updateClipping();
    int  enableOverlay(bool);
    bool event(QEvent* e);
};

#endif

