/****************************************************************************
** $Id: .emacs,v 1.3 1998/02/20 15:06:53 gis Exp $
**
** Copyright (C) 2002 Carsten Pfeiffer <pfeiffer@kde.org>
**
****************************************************************************/

#ifndef CONNECTIONEDITDIALOG_H
#define CONNECTIONEDITDIALOG_H

#include <kdialogbase.h>

#include "ksynkconnection.h"

class ConnectionEditWidget;

class ConnectionEditDialog : public KDialogBase
{
    Q_OBJECT
public:
    ConnectionEditDialog( QWidget *parent, const char *name = 0 );
    ~ConnectionEditDialog();

    void setConnection( const KSynkConnection& newConnection );
    KSynkConnection getConnection() const
    {
        return m_connection;
    }

    /**
     * @return a string to be used for ConnectionList->getConnection() to
     * find the real KSynkConnection object that is supposed to get those
     * newly configured values.
     *
     * This is the name of the KSynkConnection originally passed to
     * @ref setConnection()
     */
    QString connectionIdentifier() const
    {
        return m_connectionIdentifier;
    }

protected slots:
    virtual void accept();

private:
    KSynkConnection m_connection;
    QString m_connectionIdentifier;
    ConnectionEditWidget *m_connectionWidget;

};

#endif // CONNECTIONEDITDIALOG_H
