/***************************************************************************
                          krecursivelister.cpp  -  description
                             -------------------
    begin                : Fri Aug 31 2001
    copyright            : (C) 2001 by Jonathon Sim
    email                : jonathonsim@iname.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qtimer.h>

#include "krecursivelister.h"
#include <kdebug.h>
#include "global.h"
KRecursiveLister::KRecursiveLister(QWidget *parent, const char *name ) : QObject(parent,name) {
    lister = 0L;
    filelist.clear();
    dirlist.clear();
    dirtree.clear();
    allItems.setAutoDelete( true ); // only there to delete all items
}

KRecursiveLister::~KRecursiveLister(){
    delete lister;
}

/** Starts listing the specified url */
void KRecursiveLister::openURL(const KURL& url,bool /*_showdotfiles*/){
    filelist.clear();
    dirlist.clear();
    startListing(url);
}

/** Returns the list of fileitems found. */
const KFileItemList & KRecursiveLister::items(){
    return filelist;
}

/** handles completion of a listing. */
void KRecursiveLister::slotListingComplete(){
    kdDebug(DEBUG_AREA) << "KRecursiveLister::slotListingComplete" << endl;
    KFileItemList templist=lister->items();

    KFileItem * item;
    KFileItem * newitem;
    for( item = templist.first(); item != 0; item=templist.next() )
    {
        if (item->isDir()) {
            newitem= new KFileItem(*item);
            kdDebug(DEBUG_AREA) << "Adding dir:" << newitem->url().url()<<endl;
            dirlist.append(newitem);//Used for recursing the directories
            dirtree.append(newitem);//Returned to user on request.
            allItems.append(newitem);
        }
        else {
            newitem= new KFileItem(*item);
            kdDebug(DEBUG_AREA) << "Adding file:" << newitem->url().url()<<endl;
            filelist.append(newitem);
            allItems.append(newitem);
        }
    }

    QTimer::singleShot( 0, this, SLOT( listNextDirectory() ));
}

/** Starts listing the specified url */
void KRecursiveLister::startListing(const KURL& url){
    if (!lister) {
        lister=new KDirLister(true);
        lister->setShowingDotFiles( true );
        connect(lister,SIGNAL(completed()), this, SLOT(slotListingComplete()) );
    }

    lister->openURL( url );
}

void KRecursiveLister::listNextDirectory()
{
    if ( dirlist.isEmpty() )
        emit completed();
    else
    {
        KFileItem * nextdir=dirlist.last();
        kdDebug(DEBUG_AREA) << "Begin listing directory:" << nextdir->url().url()<<endl;
        KURL url = nextdir->url();
        dirlist.removeLast();
        startListing( url );
    }
}

/** Stops the listing */
void KRecursiveLister::stop(){
    lister->stop();
}

/** Returns the subdirectories found by the listing */
const KFileItemList& KRecursiveLister::dirs(){
    return dirtree;
}
#include "krecursivelister.moc"
