/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sat Aug 10 16:03:35 CST 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kbudget.h"

static const char *description =
	I18N_NOOP("A budgeting and money management program");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

	KAboutData aboutData( "kbudget", I18N_NOOP("KBudget"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2002, Richard Garand", 0, 0, "richard@garandnet.net");
	aboutData.addAuthor("Richard Garand",0, "richard@garandnet.net");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication app;
 
  if (app.isRestored())
  {
    RESTORE(KBudgetApp);
  }
  else 
  {
    KBudgetApp *kbudget = new KBudgetApp();
    kbudget->show();

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		
		if (args->count())
		{
        kbudget->openDocumentFile(args->arg(0));
		}
		else
		{
		  kbudget->openDocumentFile();
		}
		args->clear();
  }

  return app.exec();
}  
