/***************************************************************************
                          kbudgetdoc.h  -  description
                             -------------------
    begin                : Sat Aug 10 16:03:35 CST 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBUDGETDOC_H
#define KBUDGETDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include <qvaluelist.h>
#include <qmap.h>

// include files for KDE
#include <kurl.h>

#include "account.h"
#include "transaction.h"

// forward declaration of the KBudget classes
class KBudgetView;

/**	KBudgetDoc provides a document object for a document-view model.
  *
  * The KBudgetDoc class provides a document object that can be used in conjunction with the classes KBudgetApp and KBudgetView
  * to create a document-view model for standard KDE applications based on KApplication and KMainWindow. Thereby, the document object
  * is created by the KBudgetApp instance and contains the document structure with the according methods for manipulation of the document
  * data by KBudgetView objects. Also, KBudgetDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 1.2 code generation
  */
class KBudgetDoc : public QObject
{
  Q_OBJECT
  public:
    friend class Account;

    /** Constructor for the fileclass of the application */
    KBudgetDoc(QWidget *parent, const char *name=0);
    /** Destructor for the fileclass of the application */
    ~KBudgetDoc();

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
    void addView(KBudgetView *view);
    /** removes a view from the list of currently connected views */
    void removeView(KBudgetView *view);
    /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
    void setModified(bool _m=true);
    /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
    bool isModified(){ return modified; };
    /** "save modified" - asks the user for saving if the document is modified */
    bool saveModified();	
    /** deletes the document's contents */
    void deleteContents();
    /** initializes the document generally */
    bool newDocument();
    /** closes the acutal document */
    void closeDocument();
    /** loads the document by filename and format and emits the updateViews() signal */
    bool openDocument(const KURL& url, const char *format=0);
    /** saves the document under filename and format.*/	
    bool saveDocument(const KURL& url, const char *format=0);
    /** returns the KURL of the document */
    const KURL& URL() const;
    /** sets the URL of the document */
    void setURL(const KURL& url);

    /** return the account with the requested ID.
      * If start and end are set, returns information for that period (including start and end dates);
      * If only start is set, returns only value for the specified date;
      * Otherwise, return reference to the real account structure. */
    Account& getAccount(int id);
    /** return list of accounts.
      * If from's month is set, return account information for that month, otherwise for that year
      * If to is set, return account information between from and to (inclusive) */
    QValueList<Account> getAccounts(Account::types type, QDate from, QDate to = QDate()) const;
    /** retusn a list of all the accounts */
    QValueList<Account> getAllAccounts() const;
    /** return the transaction with the requested ID */
    Transaction& getTransaction(int id);

    /** create a new account, returns ID */
    int newAccount(Account::types type, QString name, float initialBalance);
    /** sets the name of an account */
    void setAccountName(int id, QString name);
    /** remove an account */
    void removeAccount(int id);
    /** return true if the account id is valid */
    bool isValidAccount(int id);
    
    /** create a new transaction, returns ID */
    int newTransaction(int from, int to, float value, QDate date, QString description);
    /** update a transaction */
    void updateTransaction(int id, float value, QDate date, QString description);
    /** remove a transaction */
    void removeTransaction(int id);
	
  public slots:
    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.
     */
    void slotUpdateAllViews(KBudgetView *sender);

  signals:
    /** a signal indicating that an account has changed */
    void accountChanged(int acct);
    /** a signal indicating that an account was added or removed */
    void accountAddDel();
    /** a signal indicating that the document modification status changed */
    void saveableStatus(bool status);
 	
  public:	
    /** the list of the views currently connected to the document */
    static QList<KBudgetView> *pViewList;	

  private:
    void signalAcctChanged(int acct);
    /** write the document to the specified file */
    bool writeDocument(QString file);
  
    /** the modified flag of the current document */
    bool modified;
    KURL doc_url;
    QMap<int, Account> accounts[3];
    QMap<int, Transaction> transactions;
    /** next account ID to use */
    int nextAccount;
    /** next transaction ID to use */
    int nextTransaction;
};

#endif // KBUDGETDOC_H
