/***************************************************************************
                          kbudgeteditor.h  -  description
                             -------------------
    begin                : Sat Aug 31 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: kbudgeteditor.h,v 1.3 2002/09/04 07:07:35 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBUDGETEDITOR_H
#define KBUDGETEDITOR_H

#include <qframe.h>

#include "account.h"

class KBudgetDoc;
class QDate;
class QLabel;
class KDoubleNumInput;
class QDate;

/**Displays and edits the budget values for an account
  *@author Richard Garand
  */

class KBudgetEditor : public QFrame
{
  Q_OBJECT
  public: 
    KBudgetEditor(QWidget* parent, KBudgetDoc* doc);
    virtual ~KBudgetEditor();

    /** selects a month (the value of day() is irrelevant), optionally provide
      * an account containing the data for the selected month */
    void selectMonth(QDate month, Account* acct = 0);
    /** selects an account by ID */
    void selectAccount(int id);

  public slots:
    /** changes the current month's budgeted value */
    void slotValueChanged(double value);
    /** slot to hide the panel */
    void slotHide();
    
  signals:
    /** indicates that the account has been modified, passes the account ID */
    void valueChanged(int account);

  private:
    KBudgetDoc* m_doc;
    QDate date;
    int account;

    /* widgets */
    QLabel* prevMonthLabel;
    QLabel* prevMonthValue;
    QLabel* thisMonthLabel;
    KDoubleNumInput* thisMonthValue;
    QLabel* total;
};

#endif
