/***************************************************************************
                          ktransactionwindow.cpp  -  description
                             -------------------
    begin                : Sat Sep 7 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: ktransactionwindow.cpp,v 1.6 2002/09/10 01:13:08 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kstdaction.h>
#include <kaction.h>
#include <klocale.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <qdatetime.h>
#include <qpopupmenu.h>

#include "ktransactionwindow.h"
#include "ktransactionwindow.moc"
#include "ktransactionwidget.h"
#include "kbudgetdoc.h"
#include "knewtransaction.h"

QPtrList<KTransactionWindow> KTransactionWindow::instances;

KTransactionWindow::KTransactionWindow(KBudgetDoc* doc, QDate month, int account)
  : KMainWindow(0, "transaction_window")
{
  QString longMonth = QDate::longMonthName(month.month());
  QString shortMonth = QDate::shortMonthName(month.month());
  if ( account == -1 )
    setCaption(i18n("Transactions for %1").arg(longMonth));
  else
    setCaption(i18n("Transactions for %1 (%2)").arg(longMonth).arg(doc->getAccount(account).name()));
  
  transactionWidget = new KTransactionWidget(doc, account, this, "transaction_view");
  setCentralWidget(transactionWidget);
  transactionWidget->selectMonth(month);
  connect(transactionWidget, SIGNAL(contextMenuRequested(const QPoint&)), SLOT(slotContextMenuRequested(const QPoint&)));
  connect(transactionWidget, SIGNAL(transactionFuncsEnabled(bool)), SLOT(slotTransactionFuncsEnabled(bool)));

  instances.append(this);

  (KStdAction::close(this, SLOT(slotFileClose()), actionCollection()))->setStatusText(i18n("Closes the window"));
  viewAll = new KAction(i18n("&All transactions"), "up", 0, this, SLOT(slotViewAll()), actionCollection(), "view_all");
  viewSelected = new KAction(i18n("&Transactions for %1").arg(shortMonth), "down", 0, this, SLOT(slotViewSelected()),\
    actionCollection(), "view_current");
  transactionEdit = new KAction(i18n("&Edit"), "edit", 0, this, SLOT(slotTransactionEdit()), actionCollection(), "transaction_edit");
  transactionRename = new KAction(i18n("Edit descriptio&n"), "editclear", 0, transactionWidget, SLOT(slotTransactionRename()), actionCollection(), "transaction_editComment");
  transactionDelete = new KAction(i18n("&Delete"), "editdelete", 0, transactionWidget, SLOT(slotDeleteTransaction()), actionCollection(), "transaction_delete");
  showToolbar = KStdAction::showToolbar(this, SLOT(slotToggleToolBar()), actionCollection());
  KStdAction::keyBindings(this, SLOT(slotConfKeys()), actionCollection());
  KStdAction::configureToolbars(this, SLOT(slotConfToolbar()), actionCollection());

  slotTransactionFuncsEnabled(false);

  viewAll->setStatusText(i18n("Displays all transactions for the account"));
  viewSelected->setStatusText(i18n("Displays transactions for the account in %1").arg(longMonth));
  transactionEdit->setStatusText(i18n("Edits the selected transaction"));
  transactionRename->setStatusText(i18n("Edits the selected transaction's description"));
  transactionDelete->setStatusText(i18n("Deletes the selected transaction"));

  initGUI();

  KConfig *conf = KGlobal::config();
  conf->setGroup("transactionWindow_options");
  resize(400,300);    // using random numbers ripped from KNode :)
  applyMainWindowSettings(conf);
  showToolbar->setChecked(!toolBar()->isHidden());

  mainPopup = static_cast<QPopupMenu*>(factory()->container("popup", this));
  if (!mainPopup) mainPopup = new QPopupMenu(this);
  
  m_month = month;
  m_account = account;
  m_doc = doc;
}

KTransactionWindow::~KTransactionWindow()
{
  instances.removeRef(this);
  KConfig *conf = KGlobal::config();
  conf->setGroup("transactionWindow_options");
  saveMainWindowSettings(conf);
}

bool KTransactionWindow::closeAllWindows()
{
  // TODO: limit this to the window that created this one
  QPtrList<KTransactionWindow> list = instances;
  for (KTransactionWindow* w = list.first(); w; w = list.next())
    w->close();
  return true;
}

void KTransactionWindow::slotFileClose()
{
  close();
}

void KTransactionWindow::slotViewAll()
{
  if ( m_account == -1 )
    setCaption(i18n("All transactions"));
  else
    setCaption(i18n("All transactions (%1)").arg(m_doc->getAccount(m_account).name()));
  transactionWidget->selectAll();
}

void KTransactionWindow::slotViewSelected()
{
  QString longMonth = QDate::longMonthName(m_month.month());
  if ( m_account == -1 )
    setCaption(i18n("Transactions for %1").arg(longMonth));
  else
    setCaption(i18n("Transactions for %1 (%2)").arg(longMonth).arg(m_doc->getAccount(m_account).name()));
  transactionWidget->selectMonth(m_month);
}

void KTransactionWindow::slotTransactionEdit()
{
  int id = transactionWidget->getCurrent();
  if ( id >= 0 )
    (new KNewTransaction(this, m_doc, id))->show();
}

void KTransactionWindow::slotToggleToolBar()
{
  if(toolBar()->isVisible())
    toolBar()->hide();
  else
    toolBar()->show();
}

void KTransactionWindow::slotConfKeys()
{
  KKeyDialog::configureKeys(actionCollection(), xmlFile(), true, this);
}

void KTransactionWindow::slotConfToolbar()
{
  KEditToolbar *dlg = new KEditToolbar(guiFactory(),this);
  if (dlg->exec())
    initGUI();
  delete dlg;
}

void KTransactionWindow::slotContextMenuRequested(const QPoint& p)
{
  mainPopup->popup(p);
}

void KTransactionWindow::slotTransactionFuncsEnabled(bool enabled)
{
  transactionEdit->setEnabled(enabled);
  transactionRename->setEnabled(enabled);
  transactionDelete->setEnabled(enabled);
}

void KTransactionWindow::initGUI()
{
  createGUI("ktransactionwindowui.rc");
}
