#ifndef __KMTRACELEAKSVIEWITEM__H__
#define __KMTRACELEAKSVIEWITEM__H__
 
// Qt includes
#include <qobject.h>
#include <qlistview.h>
#include <qstring.h>
 
// KDE includes
#include <klistview.h>

/**
 * The widget is an extension of a KListViewItem class. It forms
 * the view of either a @ref KMtraceLeak or a @ref KMtraceCall
 *
 * @short The widget showing an entry in the list a memory leaks
 * @author Andreas Baumann <andreas_baumann@users.sourceforge.net>
 * @see KMtraceLeaksView, KMtraceLeak, KMtraceCall
 * @version $ProjectMajorVersion: 0 $
 */
class KMtraceLeaksViewItem : public KListViewItem
{
   public:
      KMtraceLeaksViewItem( QListViewItem *parent, QString str );
      KMtraceLeaksViewItem( QListView *parent, QString s1, QString &s2,
                            QString &s3, QString &s4, QString s5);

      /**
       * Overrides the default compare method for list view items. So
       * they are ordered as integers (bytes, blocks) or not at all
       * (addresses, title field)
       *
       * @param item item to compare with
       * @param column the column to compare (the current sort order)
       * @param ascending sort ascending or descending
       * @returns -1, 0 or 1 (whether this is less, equals or bigger than item)
       */
      int compare( QListViewItem *item, int column, bool ascending ) const;

      void setModel( QObject *obj );
      QObject *getModel( );
       
   private:
      // the model of the data shown (either a leac or a call)
      QObject *m_model;
};

#endif
