/**
 * qtgtk.h
 *
 * Copyright (C)  2003  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#ifndef QTGTK_H
#define QTGTK_H

#include <glib.h>

extern "C" {
enum IntegratorType {
    Qt,   //! Integration will be based on a QApplication
    KApp, //! Integration based on a KApplication
    KUniqueApp //! Integration will be based on KUniqueApplication
};

/**
 * Integrates the given type of application in the
 * Glib event loop.
 *
 * @return returns false if the integration failed
 */
bool qtgtk_init( GMainContext *context );
bool qtgtk_init_with_type( IntegratorType type, GMainContext *context );
}

#endif
