/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klocale.h>
#include <kio/job.h>
#include <kurl.h>

// command includes
#include "deletefilescommand.h"
#include "deletefileswidget.h"
#include "deletefilesdialog.h"

using namespace WorKflow;

DeleteFilesCommand::DeleteFilesCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  DeleteFilesWidget* w = new DeleteFilesWidget(this);
  setWidget(w);
}

DeleteFilesCommand::~DeleteFilesCommand()
{
}

void DeleteFilesCommand::execute()
{
  QStringList files = value("input").asStringList();
  bool ask = value("ask").nextBoolean();
  int mode = value("trashordelete").nextNumber();

  if (ask) {
    DeleteFilesDialog::Answer ans;
    if (mode == 0) {
      ans = DeleteFilesDialog::trash(widget(), files);
    } else {
      ans = DeleteFilesDialog::del(widget(), files);
    }

    if (ans == DeleteFilesDialog::Cancel) {
      emit aborted();
      return;
    } else if (ans == DeleteFilesDialog::No) {
      return;
    }
  }

  m_prog = 0;

  emit progress(0, i18n("Getting file list"));

  KIO::Job* job;
  KURL::List list(files);
  if (mode == 0) {
    // trash
    KIO::CopyJob* j = KIO::trash(list, false);
    connect(j, SIGNAL(copying(KIO::Job*, const KURL&, const KURL&)), this, SLOT(showProgress(KIO::Job*, const KURL&)));

    job = j;
  } else {
    // delete
    KIO::DeleteJob* j = KIO::del(list, false, false);
    connect(j, SIGNAL(deleting(KIO::Job*, const KURL&)), this, SLOT(showProgress(KIO::Job*, const KURL&)));

    job = j;
  }

  connect(job, SIGNAL(percent(KIO::Job*, unsigned long)), this, SLOT(setPercent(KIO::Job*, unsigned long)));

  waitFor(job, SIGNAL(result(KIO::Job*)));
}

void DeleteFilesCommand::showProgress(KIO::Job*, const KURL& source)
{
  emit progress(m_prog, i18n("Deleting file %1").arg(source.url()));
}

void DeleteFilesCommand::setPercent(KIO::Job*, unsigned long percent)
{
  m_prog = double(percent) / 100.0;
}

#include "deletefilescommand.moc"
