/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klistbox.h>
#include <klocale.h>
#include <kpushbutton.h>

// Qt includes
#include <qlabel.h>

// command includes
#include "deletefilesdialog.h"

DeleteFilesDialog::Answer DeleteFilesDialog::del(QWidget* parent, const QStringList& files)
{
  DeleteFilesDialog dialog(parent, files, false);
  dialog.exec();
  return dialog.answer();
}

DeleteFilesDialog::Answer DeleteFilesDialog::trash(QWidget* parent, const QStringList& files)
{
  DeleteFilesDialog dialog(parent, files, true);
  dialog.exec();
  return dialog.answer();
}

DeleteFilesDialog::DeleteFilesDialog(QWidget* parent, const QStringList& files, bool trash)
  : DeleteFilesDialogBase(parent)
{
  m_listBox->insertStringList(files);

  int count = files.count();
  if (trash) {
    m_deleteButton->setText(i18n("Trash"));

    if (count == 1)
      m_promptLabel->setText(i18n("Do you really want to move this item to the trash?"));
    else
      m_promptLabel->setText(i18n("Do you really want to move these %1 items to the trash?").arg(count));
  } else {
    if (count == 1)
      m_promptLabel->setText(i18n("Do you really want delete this item?"));
    else
      m_promptLabel->setText(i18n("Do you really want delete these %1 items?").arg(count));
  }
}

DeleteFilesDialog::~DeleteFilesDialog()
{
}

void DeleteFilesDialog::accept()
{
  m_answer = Delete;
  QDialog::accept();
}

void DeleteFilesDialog::reject()
{
  m_answer = Cancel;
  QDialog::reject();
}

void DeleteFilesDialog::slotNoPressed()
{
  m_answer = No;
  QDialog::accept();
}

DeleteFilesDialog::Answer DeleteFilesDialog::answer()
{
  return m_answer;
}

#include "deletefilesdialog.moc"
