/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kgenericfactory.h>

// WorKflow includes
#include "imagelibrary.h"
#include "commandfactory.h"

// commands
#include "convertimagecommand.h"
#include "flipimagecommand.h"
#include "rotateimagecommand.h"
#include "scaleimagecommand.h"

using namespace WorKflow;

typedef KGenericFactory<ImageLibrary> LibraryFactory;
K_EXPORT_COMPONENT_FACTORY(libworkflow_imagecommands, LibraryFactory("libworkflow_imagecommands"))

ImageLibrary::ImageLibrary(QObject* parent, const char* name, const QStringList& args)
  : Library(parent, name, args)
{
}

ImageLibrary::~ImageLibrary()
{
}

void ImageLibrary::init()
{
  addCommandFactory(new CommandFactory<ConvertImageCommand>("org.kde.Image.ConvertImage"));
  addCommandFactory(new CommandFactory<FlipImageCommand>("org.kde.Image.FlipImages"));
  addCommandFactory(new CommandFactory<RotateImageCommand>("org.kde.Image.RotateImages"));
  addCommandFactory(new CommandFactory<ScaleImageCommand>("org.kde.Image.ScaleImages"));
}

#include "imagelibrary.moc"
