/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kstandarddirs.h>

// Qt includes
#include <qimage.h>
#include <qtimer.h>

// WorKflow includes
#include "imageviewer.h"

// widget includes
#include "previewwidget.h"

PreviewWidget::PreviewWidget(QWidget* parent, const char* name, WFlags fl)
    : PreviewWidgetBase(parent,name,fl)
{
  QTimer::singleShot(0, this, SLOT(init()));
}

PreviewWidget::~PreviewWidget()
{
}

void PreviewWidget::init()
{
  KStandardDirs dirs;
  m_imagePath = dirs.findResource("data", "workflow/example.png");
  QImage image;
  image.load(m_imagePath);

  m_originalViewer->setImage(image);
  m_processedViewer->setImage(image);
}

void PreviewWidget::setOriginalImage(const QString& fileName)
{
  m_imagePath = fileName;
  m_originalViewer->setImage(fileName);
}

void PreviewWidget::setProcessedImage(const QString& fileName)
{
  m_processedViewer->setImage(fileName);
}

void PreviewWidget::slotDropped(const QString& fileName)
{
  m_imagePath = fileName;
  emit imageDropped(fileName);
}

QString PreviewWidget::originalImagePath() const
{
  return m_imagePath;
}

#include "previewwidget.moc"
