/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <ktempfile.h>

// WorKflow includes
#include "buttongroup.h"
#include "previewwidget.h"
#include "slider.h"
#include "checkbox.h"

// command includes
#include "rotateimagewidget.h"
#include "rotateimagecommand.h"

using namespace WorKflow;

RotateImageWidget::RotateImageWidget(Command* command)
  : RotateImageWidgetBase(0)
{
  setCommand(command);
}

RotateImageWidget::~RotateImageWidget()
{
}

void RotateImageWidget::updatePreview()
{
  int degrees;

  switch (m_rotateButtonGroup->selectedId()) {
    case 0: degrees = 90; break;
    case 1: degrees = -90; break;
    case 2: degrees = 180; break;
    case 3: degrees = m_degreeSlider->QSlider::value(); break;
  }

  KTempFile file(QString::null, ".png");
  file.setAutoDelete(true);
  RotateImageCommand::rotateImage(degrees, m_imagePreview->originalImagePath(), file.name());
  m_imagePreview->setProcessedImage(file.name());
}

void RotateImageWidget::slotInteractiveChanged()
{
  bool interactive = m_interactiveCheckBox->isChecked();

  m_rotateButtonGroup->setEnabled(!interactive);
  m_imagePreview->setHidden(interactive);
}

#include "rotateimagewidget.moc"
