/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kapplication.h>

// Qt includes
#include <qclipboard.h>
#include <qlistbox.h>

// commmand includes
#include "outputdialog.h"

OutputDialog::OutputDialog(QWidget* parent, const QStringList& output)
  : OutputDialogBase(parent, 0, true)
{
  m_outputListBox->insertStringList(output);
  m_output = output.join("\n");
}

OutputDialog::~OutputDialog()
{
}

void OutputDialog::copy()
{
  KApplication::clipboard()->setText(m_output, QClipboard::Clipboard);
}

#include "outputdialog.moc"
