/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// commmand includes
#include "showoutputcommand.h"
#include "showoutputwidget.h"
#include "outputdialog.h"

using namespace WorKflow;

ShowOutputCommand::ShowOutputCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  ShowOutputWidget* w = new ShowOutputWidget(this);
  setWidget(w);
}

ShowOutputCommand::~ShowOutputCommand()
{
}

void ShowOutputCommand::execute()
{
  // That's no typo :)
  QStringList output = value("input").asStringList();

  if (value("enabled").nextBoolean()) {
    OutputDialog dialog(widget(), output);

    if (dialog.exec() == QDialog::Rejected)
      emit aborted();
  }

  Command::execute();
}

#include "showoutputcommand.moc"
