/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWAPPLICATIONINSTANCE_H
#define WORKFLOWAPPLICATIONINSTANCE_H

// Qt includes
#include <qstring.h>
#include <qstringlist.h>

// forward declarations
namespace WorKflow
{
  class ApplicationDescription;
}

namespace WorKflow
{
  /**
   * @author Thomas Kadauke <tkadauke@gmx.de>
   */
  class Application
  {
  public:
    Application(ApplicationDescription* app, const QString& dcopid);
    virtual ~Application();

//     ApplicationDescription* application();
    QString id();
    int pid();
    QString dcopName();

    bool isUnique();
    bool isRunning();

    virtual QStringList actions();
    virtual QString actionName(const QString& actionId);
    virtual void executeAction(const QString& actionId);

    void terminate();

  private:
    ApplicationDescription* m_description;
    QString m_dcopName;
    bool m_running;
  };
}

#endif
