/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// Qt includes
#include <qdom.h>

// WorKflow includes
#include "applicationdescription.h"
#include "application.h"
#include "applicationmanager.h"
#include "librarydescription.h"

using namespace WorKflow;

ApplicationDescription::ApplicationDescription(LibraryDescription* parent)
  : XMLDescription(), m_parent(parent)
{
  if (m_parent)
    m_parent->addApplication(this);
}

ApplicationDescription::~ApplicationDescription()
{
  ApplicationManager::unregisterApplication(this);
  if (m_parent)
    m_parent->removeApplication(this);
}

void ApplicationDescription::readXML(const QDomElement& e)
{
  XMLDescription::readXML(e);

  m_unique = (e.attribute("unique") == "true");
  m_exeName = e.attribute("exename");
  m_dcopName = e.attribute("dcopname");

  ApplicationManager::registerApplication(this);
}

void ApplicationDescription::writeXML(QDomDocument& doc, QDomElement& e)
{
  QDomElement app = doc.createElement("application");
  app.setAttribute("unique", (m_unique ? "true" : "false"));
  app.setAttribute("exename", m_exeName);
  app.setAttribute("dcopname", m_dcopName);

  XMLDescription::writeXML(doc, app);

  e.appendChild(app);
}

void ApplicationDescription::addInstance(Application* instance)
{
  m_instances.append(instance);
}

void ApplicationDescription::removeInstance(Application* instance)
{
  m_instances.erase(m_instances.find(instance));
}

ApplicationDescription::List ApplicationDescription::instances()
{
  return m_instances;
}

ApplicationDescription::List ApplicationDescription::runningInstances()
{
  List result;
  for (List::ConstIterator i = m_instances.begin(); i != m_instances.end(); ++i)
    if ((*i)->isRunning())
      result.append(*i);
  return result;
}

void ApplicationDescription::setFactory(ApplicationFactoryBase* factory)
{
  m_factory = factory;
}

ApplicationFactoryBase* ApplicationDescription::factory() const
{
  return m_factory;
}

QString ApplicationDescription::executableName() const
{
  return m_exeName;
}

QString ApplicationDescription::dcopName() const
{
  return m_dcopName;
}

bool ApplicationDescription::isUnique()
{
  return m_unique;
}

void ApplicationDescription::setExecutableName(const QString& name)
{
  m_exeName = name;
}

void ApplicationDescription::setDcopName(const QString& name)
{
  m_dcopName = name;
}

void ApplicationDescription::setUnique(bool unique)
{
  m_unique = unique;
}
