/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// Qt includes
#include <qmap.h>

// WorKflow includes
#include "commandmanager.h"
#include "commanddescription.h"
#include "category.h"

using namespace WorKflow;

class CommandManager::Private
{
public:
  static CommandManager* self;

  DescriptionList commands;
  CategoryList categories;

  typedef QMap<QString, CommandDescription*> ComDescMap;

  ComDescMap comDescMap;
};

CommandManager* CommandManager::Private::self = 0;

CommandManager* CommandManager::self()
{
  if (!Private::self) {
    Private::self = new CommandManager();
  }
  return Private::self;
}

void CommandManager::registerCategory(Category* cat)
{
  d->categories.append(cat);
}

void CommandManager::unregisterCategory(Category* cat)
{
  d->categories.erase(d->categories.find(cat));
}

CommandManager::CategoryList CommandManager::categories()
{
  return d->categories;
}

CommandManager::DescriptionList CommandManager::allCommands()
{
  return d->commands;
}

CommandManager::DescriptionList CommandManager::commands(const QString& cat)
{
  DescriptionList result;
  for (DescriptionList::ConstIterator i = d->commands.begin(); i != d->commands.end(); ++i) {
    if ((*i)->categories().contains(cat))
      result.append(*i);
  }
  return result;
}

Category* CommandManager::findCategory(const QString& id)
{
  for (CategoryList::ConstIterator i = d->categories.begin(); i != d->categories.end(); ++i) {
    if ((*i)->id() == id)
      return *i;
  }

  return 0;
}

CommandManager::CommandManager()
{
  d = new Private;
}

CommandManager::~CommandManager()
{
  delete d;
}

void CommandManager::addCommandDescription(const QString& id, CommandDescription* desc)
{
  d->commands.append(desc);
  d->comDescMap[id] = desc;
}

void CommandManager::removeCommandDescription(const QString& id)
{
  CommandDescription* desc = commandDescription(id);
  if (desc) {
    d->commands.erase(d->commands.find(desc));
    d->comDescMap.erase(id);
  }
}

CommandDescription* CommandManager::commandDescription(const QString& id)
{
  if (d->comDescMap.contains(id))
    return d->comDescMap[id];
  return 0;
}

CommandManager::DescriptionList CommandManager::queryForDropType(const QString& type)
{
  DescriptionList result;
  // TODO:!!!!
/*  for (DescriptionList::ConstIterator i = d->commands.begin(); i != d->commands.end(); ++i) {
    if ((*i)->acceptsDrop(type))
      result.append(*i);
  }*/
  return result;
}
